//
// Filename: pagesensor.h
//
// Flexbook page for page A1.
//

// include guards
#ifndef PAGESENSOR_H
#define PAGESENSOR_H

#include "page.h"
#include "pagedice.h"
#include "pageoled.h"
#include "mcp23s17.h"
#include "hal.h"

#include <stdint.h>

namespace Flexbook
{

// Sensor data.
struct SensorData
{
    SensorData()
    : temperature(0), pressure(0), dice(1)
    {
    }

    uint8_t temperature;
    uint8_t pressure;
    uint8_t dice;
};

bool operator!=(const SensorData &lhs, const SensorData &rhs);

class PageSensor : public Page
{
public:
    // Constructor needs to be explicit.
    explicit PageSensor();

    // Destructor.
    virtual ~PageSensor();

    virtual void HandlePageActions();

private:
    // Disable the copy constructor.
    PageSensor(const PageSensor &);

    // Disable assignment.
    PageSensor &operator=(const PageSensor &);
    
    void SensorPoll();
    //void HandleDice();
    uint8_t BinTemp(uint16_t TempSensorReading);
    uint8_t BinPres(uint16_t PresSensorReading);

    PageOLED pageoled;
    //PageDice pagedice;
    
    SensorData sensordata;
};

} // End Flexbook namespace.

#endif // PAGESENSOR_H

