//
// Filename: pagedice.h
//
// Flexbook page for page A2.
//

// include guards
#ifndef PAGEDICE_H
#define PAGEDICE_H

#include "page.h"
#include "hal.h"
#include "mcp23s17.h"
#include "pageoled.h"

namespace Flexbook
{

struct SensorData;

class PageDice : public Page
{
public:
    // Constructor needs to be explicit.
    explicit PageDice();

    // Destructor.
    virtual ~PageDice();
    
    virtual void HandlePageActions();

    uint8_t DiceValue();
    //uint8_t dicenr;

private:
    // Disable the copy constructor.
    PageDice(const PageDice &);

    // Disable assignment.
    PageDice &operator=(const PageDice &);
    
    //void HandleDice();
    PageOLED pageoled;
    uint8_t DicePoll();
};

} // End Flexbook namespace.

#endif // PAGEDICE_H



