//
// Filename: page.h
//
// Base class for Flexbook pages.
//

#include "page.h"
#include "mbed.h"

#include <iostream>

namespace Flexbook {

Page::Page()
: buzzer(p21)
{
}

Page::~Page()
{
}

void Page::HandlePageActions()
{
}

//start mfb adds
void Page::Beep(int duration_ms)
{
    buzzer = 1;
    wait_ms(duration_ms);
    buzzer = 0;
}

void Page::ShortBeep()
{
    Beep(100);
}

void Page::MultiBeep(int number, int interval_ms)
{
    for(int i=0; i<number; i++)
    {
        Beep(100);
        wait_ms(interval_ms);
    }
}

void Page::TripleBeep()
{
    MultiBeep(3, 300);
}


//end mfb adds

} // End Flexbook namespace.




