//
// Filename: i2c_utils.h
//
// I2C utilities.
//

#ifndef I2C_UTILS_H
#define I2C_UTILS_H

#include "mbed.h"

/**
 * @brief Get the end of I2C address iterator.
 * @return One past the end of the I2C address range.
 */
uint16_t GetAddressRangeEnd(uint16_t bits);

/**
 * @brief Scan the I2C bus for responding devices.
 * Currently 7 or 10 bit address ranges are supported.
 * @param i2c The I2C device to use.
 * @param bits The number of allowed address bits.
 */
void I2C_Scan(I2C &i2c, uint16_t bits = 7);

#endif // I2C_UTILS_H
