//
// Filename: bookmonitor.h
//
// Flexbook page turn monitor.
//

// include guards
#ifndef BOOKMONITOR_H
#define BOOKMONITOR_H

namespace Flexbook
{

class Book;

class BookMonitor
{
public:
    // Constructor needs to be explicit.
    explicit BookMonitor(Book &book);

    // Destructor.
    ~BookMonitor();

    // Check for a page turn.
    void CheckForPageChange();
  
private:
    // Disable the copy constructor.
    BookMonitor(const BookMonitor &);

    // Disable assignment.
    BookMonitor &operator=(const BookMonitor &);

    Book &book;
};

} // End Flexbook namespace.

#endif // BOOKMONITOR_H

