//
// Filename: bookmonitor.h
//
// Flexbook page turn monitor.
//

#include "bookmonitor.h"

#include "book.h"
#include "hal.h"
#include "log.h"
#include "pagefactory.h"

#include <iostream>

namespace Flexbook {

BookMonitor::BookMonitor(Book &book)
: book(book)
{
    Log("Creating BookMonitor");
}

BookMonitor::~BookMonitor()
{
    Log("Deleting BookMonitor");
}

void BookMonitor::CheckForPageChange()
{
    PageType hardwaretype = HAL::GetPageType();

    if(book.GetPageType() != hardwaretype)
    {
        book.PageChange(hardwaretype);
    }
}

} // End Flexbook namespace.


