//
// Filename: book.h
//
// Container for Flexbook pages.
//

#include "book.h"

#include "log.h"
#include "pagefactory.h"
#include "page.h"

#include <iostream>

namespace Flexbook {

Book::Book(PageFactory &thefactory)
: factory(thefactory),
  pagetype(PageType_PageNull),
  page(nullptr)
{
    Log("Creating Book");
}

Book::~Book()
{
    Log("Deleting Book");
}

void Book::PageChange(PageType type)
{
    Log("Page change");
    
    // Delete the old page.
    page.reset();
    pagetype = PageType_PageNull;

    // Create the new page and any of it's dependencies.
    page = factory.CreatePages(type);
    pagetype = type;
}

PageType Book::GetPageType() const
{
    return pagetype;
}

void Book::HandleActions()
{
    if(page.get())
        page->HandlePageActions();
}

} // End Flexbook namespace.


