//
// Filename: pagetouch.h
//
// Flexbook page for page A4.
//

// include guards
#ifndef PAGETOUCH_H
#define PAGETOUCH_H

#include "page.h"
#include "pageflexenable.h"
#include "hangman.h"
#include "eink.h"

#include "mbed.h"

#include "at42qt2120.h"

namespace Flexbook
{

class PageTouch : public Page
{
public:
    // Constructor needs to be explicit.
    explicit PageTouch();

    // Destructor.
    virtual ~PageTouch();
    
    //virtual void HandlePageActions();

    int GetKey();
    
private:
    // Disable the copy constructor.
    PageTouch(const PageTouch &);

    // Disable assignment.
    PageTouch &operator=(const PageTouch &);

    void TouchChange();
    PageFlexEnable pageflexenable;
    HangmanGame hangmangame;

    // Touch sensor.
    I2C i2c;
    InterruptIn irq;
    HAL::AT42QT2120 at42qt2120;
    
    int key;
    bool newtouch;
    int imgnumber;

};

} // End Flexbook namespace.

#endif // PAGETOUCH_H

