//
// Filename: pagesensor.cpp
//
// Flexbook page for page A1.
//

#include "pagesensor.h"
#include "mcp23s17.h"
#include "hal.h"


#include "log.h"

#include <iostream>

namespace Flexbook {

// Ticker sensorpoller;
// const int POLL_PERIOD = 0.1;

bool operator!=(const SensorData &lhs, const SensorData &rhs)
{
    return lhs.temperature != rhs.temperature || lhs.pressure != rhs.pressure;
}

PageSensor::PageSensor()
: pageoled(),
  sensordata()
{
    Log("Creating PageSensor");

    //sensorpoller.attach(callback(this, &Flexbook::PageSensor::SensorPoll), POLL_PERIOD);
}

PageSensor::~PageSensor()
{
    Log("Deleting PageSensor");

    //sensorpoller.detach();
}

void PageSensor::HandlePageActions()
{
    //uint8_t dicenumber = PageDice::DiceValue();
    SensorPoll();
    //HandleDice();
    /*pagedice.HandlePageActions();

    if(sensordata != lastsensordata)
    {
        //pagedice.SensorPoll(sensordata);
        //pageoled.SensorPoll(sensordata);
        lastsensordata = sensordata;
    }
    
    pagedice.HandlePageActions();
        //pageoled.HandlePageActions();
    */

    pageoled.SensorPoll(sensordata);
    //pagedice.HandlePageActions();

}



// The BinTemp function takes the raw 16-bit AnalogIn data for the temperature sensor
// and compares it to 7 binning values. It returns the bin number 0..6 which is the
// number of segments of the OLED bar graph to light up
uint8_t PageSensor::BinTemp(uint16_t TempSensorReading)
{
    // The 7 values in this array are the lowest values of each "bin"
    // The values must be sorted from low to high, between 0x0000 and 0xFFFF
    const uint16_t TempBinArray[7] = {53500, 53600, 53700, 53800, 53900, 54000, 54100};
    uint8_t RetValue = 0;
    for (int i=0; i<7; i++)
    {
        if (TempSensorReading >= TempBinArray[i])
        {
            RetValue = (7-i);
        }
    }
    return(RetValue);
}

// The BinPres function takes the raw 16-bit AnalogIn data for the presssure sensor
// and compares it to 7 binning values. It returns the bin number 0..6 which is the
// number of segments of the OLED bar graph to light up
uint8_t PageSensor::BinPres(uint16_t PresSensorReading)
{
    // The 7 values in this array are the lowest values of each "bin"
    // The values must be sorted from low to high, between 0x0000 and 0xFFFF
    const uint16_t PresBinArray[7] = {0x0800, 0x0B00, 0x1000, 0x1400, 0x1800, 0x1B00, 0x2000};
    uint8_t RetValue = 0;
    for (int i=0; i<7; i++)
    {
        if (PresSensorReading >= PresBinArray[i])
        {
            RetValue = (7-i);
        }
    }
    return(RetValue);
}
    
void PageSensor::SensorPoll()
{
    //sensorpoller.detach();
    
    AnalogIn RawTemp(p15);
    AnalogIn RawPres(p16);
    //printf("%i  %i  \n", RawTemp, RawPres);
    sensordata.temperature = BinTemp(RawTemp.read_u16());
    sensordata.pressure = BinPres(RawPres.read_u16());
       
    //sensorpoller.attach(callback(this, &Flexbook::PageSensor::SensorPoll), POLL_PERIOD);
}

} // End Flexbook namespace.




