//
// Filename: pageoled.cpp
//
// Flexbook page for page A3.
//

#include "pageoled.h"
#include "pagesensor.h"

#include "log.h"

#include <iostream>

namespace Flexbook {

PageOLED::PageOLED()
: data(p9), clock(p10), strobe(p11), enable(p12)
{
    Log("Creating PageOLED");

    data = 0;
    clock = 0;
    strobe = 0;
    enable = 1;
    
    Write(0xffffffffffff);
    wait(1.0);
    
    // test case follows
    //Write(Translate(0,0,1,2,3,10));
    //wait(2.0);
    
   /*
    for (int i=0; i<200; i++) {
        Write(Translate(0,0,0,0,0,i % 6));
        if (i<120) wait_ms(30);
            else wait_ms(i);
        }

        
    for (int i=0; i<600; i++) {
        Write(Translate(i%6,i%6,0,0,i*7%6,i%10));
        wait(0.5);
        }    
        
    uint64_t oledpixels = 63;
    for(int i=0; i<43; i++) {
        Write(oledpixels);
        oledpixels = 1 + (oledpixels * 2);
        wait(0.5);
        }
        
    wait(5.0);
    */
    // test case ends
    
    Write(0x000000000000);
}

PageOLED::~PageOLED()
{
    Log("Deleting PageOLED");
}

// Write data to OLED.
void PageOLED::Write(uint64_t writedata)
{
    strobe = 1;
    enable = 1;

    for(int bit = 0; bit < 48; bit++)
    {
        data = writedata & 1;
        clock = 1;
        writedata = writedata >> 1;
        clock = 0;
    }

    strobe = 0;
    enable = 0;
}

uint64_t PageOLED::Translate(char b1, char b2, char b3, char b4, char b5, char d1)
// b1..b5 should be a number 0..6 - the number of bars lit in each of the five bar graphs
// d1 should be a number 0..9 - and is displayed as a single digit
{
    uint64_t result = 0; //start with 0, each addition only changes a single bit
    
    //create bit pattern for leftmost bar graph (No. 1)
    if (b1>6) result = result + (0x010000000000); //bit 40 - not connected on new OLEDS
    if (b1>5) result = result + (0x020000000000); //bit 41
    if (b1>4) result = result + (0x040000000000); //bit 42
    if (b1>3) result = result + (0x080000000000); //bit 43
    if (b1>2) result = result + (0x000800000000); //bit 35
    if (b1>1) result = result + (0x000400000000); //bit 34
    if (b1>0) result = result + (0x000200000000); //bit 33
    
    //create bit pattern for second bar graph
    if (b2>6) result = result + (0x000100000000); //bit 32 - not connected on new OLEDS
    if (b2>5) result = result + (0x800000000000); //bit 47
    if (b2>4) result = result + (0x400000000000); //bit 46
    if (b2>3) result = result + (0x200000000000); //bit 45
    if (b2>2) result = result + (0x100000000000); //bit 44
    if (b2>1) result = result + (0x001000000000); //bit 36
    if (b2>0) result = result + (0x002000000000); //bit 37
    
    //create bit pattern for third bar graph
    if (b3>6) result = result + (0x004000000000); //bit 38 - not connected on new OLEDS
    if (b3>5) result = result + (0x008000000000); //bit 39
    if (b3>4) result = result + (0x000001000000); //bit 24
    if (b3>3) result = result + (0x000002000000); //bit 25
    if (b3>2) result = result + (0x000004000000); //bit 26
    if (b3>1) result = result + (0x000008000000); //bit 27
    if (b3>0) result = result + (0x000000080000); //bit 19
    
    //create bit pattern for fourth bar graph
    if (b4>6) result = result + (0x000000040000); //bit 18 - not connected on new OLEDS
    if (b4>5) result = result + (0x000000020000); //bit 17
    if (b4>4) result = result + (0x000000010000); //bit 16
    if (b4>3) result = result + (0x000080000000); //bit 31
    if (b4>2) result = result + (0x000040000000); //bit 30
    if (b4>1) result = result + (0x000020000000); //bit 29
    if (b4>0) result = result + (0x000010000000); //bit 28
    
    //create bit pattern for fifth (rightmost) bar graph
    if (b5>6) result = result + (0x000000100000); //bit 20 - not connected on new OLEDS
    if (b5>5) result = result + (0x000000200000); //bit 21
    if (b5>4) result = result + (0x000000400000); //bit 22
    if (b5>3) result = result + (0x000000800000); //bit 23
    if (b5>2) result = result + (0x000000000100); //bit 8
    if (b5>1) result = result + (0x000000000200); //bit 9
    if (b5>0) result = result + (0x000000000400); //bit 10
    
    //create bit pattern for digit - each digit needs multiple segments to be lit
    //7 segments use bits 6, 7, 11, 12, 13, 14 and 15
    switch (d1) {
        case 0: result = result + (0x01E3 << 6); break; //0001 1110 0011
        case 1: result = result + (0x0042 << 6); break; //0000 0100 0010
        case 2: result = result + (0x0383 << 6); break; //0011 1000 0011
        case 3: result = result + (0x02C3 << 6); break; //0010 1100 0011
        case 4: result = result + (0x0262 << 6); break; //0010 0110 0010
        case 5: result = result + (0x02E1 << 6); break; //0010 1110 0001
        case 6: result = result + (0x03E1 << 6); break; //0011 1110 0001
        case 7: result = result + (0x0043 << 6); break; //0000 0100 0011
        case 8: result = result + (0x03E3 << 6); break; //0011 1110 0011
        case 9: result = result + (0x02E3 << 6); break; //0010 1110 0011
        }
    //Note least significant 6 bits (0..5) are not used
          
    return(result);
}

void PageOLED::SensorPoll(const SensorData &sensordata)
{
    Write(Translate(3,sensordata.temperature,4,sensordata.pressure,2,sensordata.pressure));
    //printf("%i \n", sensordata.temperature);
    
}

void PageOLED::DiceRoll(const int dicenr)
{
    
}

void PageOLED::HandlePageActions ()
{
    //Write(Translate(0,sensordata.temperature,0,sensordata.pressure,0,3));
    Log("OLED updated");
}

} // End Flexbook namespace.






