//
// Filename: pageflexenable.cpp
//
// Flexbook page for page A5.
//

#include "pageflexenable.h"
#include "eink.h"
#include "log.h"
#include <iostream>

namespace Flexbook {

PageFlexEnable::PageFlexEnable()
:
  // TPS65185 signals.
  i2c(p9, p10),
  hven(p18), hvpok(p23),
  
  // EPSON controller signals.
  spi(p11, p12, p13), spics(p14),
  hirq(p15), rst(p16), vcom_sw(p17),
  hdc(p24)
{
    Log("Creating PageFlexEnable");
    numimage = 0;
    InitDisplay(i2c, spi, spics, hven, rst, hvpok);    
}

PageFlexEnable::~PageFlexEnable()
{
    Log("Deleting PageFlexEnable");
}

void PageFlexEnable::UpdateImage()
{
    printf("UpdateImage in pageflexenable\n");
    WriteImage(numimage);
}

} // End Flexbook namespace.



