//
// Filename: pagefactory.h
//
// Flexbook page creator.
//

#include "pagefactory.h"

#include "hal.h"
#include "log.h"

#include "pagesensor.h"
#include "pagedice.h"
#include "pageoled.h"
#include "pagetouch.h"
#include "pageflexenable.h"
#include "pagenfc.h"

#include <iostream>

namespace Flexbook {

PageFactory::PageFactory()
{
    Log("Creating PageFactory");
}

PageFactory::~PageFactory()
{
    Log("Deleting PageFactory");
}

BookPage PageFactory::CreatePages(PageType &type)
{

    switch(type)
    {
        case PageType_PageSensor:

            HAL::EnablePowerToPages(PageType_PageSensor | PageType_PageOLED);
            return BookPage(new PageSensor);

        case PageType_PageDice:
            
            HAL::EnablePowerToPages(PageType_PageDice | PageType_PageOLED);
            return BookPage(new PageDice);

        case PageType_PageOLED:

            HAL::EnablePowerToPages(PageType_PageOLED);
            return BookPage(new PageOLED);

        case PageType_PageTouch:

            HAL::EnablePowerToPages(PageType_PageTouch | PageType_PageFlexEnable);
            return BookPage(new PageTouch);

        case PageType_PageFlexEnable:

            HAL::EnablePowerToPages(PageType_PageFlexEnable);
            return BookPage(new PageFlexEnable);

        case PageType_PageNFC:

            HAL::EnablePowerToPages(PageType_PageNFC);
            return BookPage(new PageNFC);

        case PageType_PageNull:

            HAL::EnablePowerToPages(PageType_PageNull);
            Log("NULL page");
            break;

        default:

            Log("Error - unknown page type");
            break;
    }
    
    return BookPage(nullptr);
}

} // End Flexbook namespace.



