//
// Filename: page.h
//
// Base class for Flexbook pages.
//

// include guards
#ifndef PAGE_H
#define PAGE_H

#include <memory>
#include "mbed.h"

namespace Flexbook
{

class Page
{
public:
    // Constructor needs to be explicit.
    explicit Page();

    // Destructor needs to be virtual for a polymorphic base class.
    virtual ~Page();

    // Handle any page actions.
    virtual void HandlePageActions();
    
    //start mfb adds
    // Basic single beep
    void Beep(int duration_ms);
    
    // Short single beep
    void ShortBeep();
    
    // Triple beeps
    void TripleBeep();
    
    // Multiple beeps
    void MultiBeep(int number, int interval_ms);
    
    DigitalOut buzzer;
    //end mfb adds
    
private:
    // Disable the copy constructor.
    Page(const Page &);

    // Disable assignment.
    Page &operator=(const Page &);
    
};


// Kludge to account for mbeds lack of C++11 support.
#if(__cplusplus == 199711L)
typedef std::auto_ptr<Page> BookPage;
#define nullptr NULL
#else
typedef std::unique_ptr<Page> BookPage;
#endif

} // End Flexbook namespace.

#endif // PAGE_H

