//
// Filename: hal.h
//
// Flexbook Hardware Abstraction Layer.
//

#ifndef HAL_H
#define HAL_H

#include "pagefactory.h"

/**
 * @brief Namespace to contain all Hardware Abstraction Layer functions.
 */
namespace HAL {

/**
 * @brief Initialise the HAL.
 * This must be called before accessing any hardware functions.
 */
void Initialise();

/**
 * @brief Enable the indicated pages.
 * This should be called before creating pages to ensure that they are powered.
 * pages A bit mask of the pages to be powered.
 */
void EnablePowerToPages(Flexbook::PageType pages);

/**
 * @brief Read the current page type from the hardware.
 * @return The selected hardware page type.
 */
Flexbook::PageType GetPageType();

class MCP23S17;
MCP23S17 &GetMCP23S17();

} // End HAL namespace.

#endif // HAL_H
