//
// Filename: pageflexenable.h
//
// Flexbook page for page A5.
//

// include guards
#ifndef PAGEFLEXENABLE_H
#define PAGEFLEXENABLE_H

#include "page.h"
#include "mbed.h"

namespace Flexbook
{

class PageFlexEnable : public Page
{
public:
    // Constructor needs to be explicit.
    explicit PageFlexEnable();

    // Destructor.
    virtual ~PageFlexEnable();
    void UpdateImage();
    int numimage;

private:
    // Disable the copy constructor.
    PageFlexEnable(const PageFlexEnable &);

    // Disable assignment.
    PageFlexEnable &operator=(const PageFlexEnable &);
    

    
    // TPS65185 signals.
    I2C        i2c;
    DigitalOut hven;
    DigitalIn  hvpok;

    // EPSON controller signals.
    SPI        spi;
    DigitalOut spics;
    DigitalOut hirq;
    DigitalOut rst;
    DigitalOut vcom_sw;
    DigitalOut hdc;  
};

} // End Flexbook namespace.

#endif // PAGEFLEXENABLE_H



