//
// Filename: pagefactory.h
//
// Flexbook page creator.
//

// include guards
#ifndef PAGEFACTORY_H
#define PAGEFACTORY_H

#include "book.h"

#include <memory>

namespace Flexbook
{

typedef int PageType;

class Page;

enum
{
PageType_PageSensor =     (1 << 0),
PageType_PageTouch =      (1 << 1),
PageType_PageNFC =        (1 << 2),
PageType_PageFlexEnable = (1 << 6),
PageType_PageOLED =       (1 << 7),
PageType_PageDice =       (1 << 3),
PageType_PageNull =        0
};

class PageFactory
{
public:
    // Constructor needs to be explicit.
    explicit PageFactory();

    // Destructor.
    ~PageFactory();

    BookPage CreatePages(PageType &type);
  
private:
    // Disable the copy constructor.
    PageFactory(const PageFactory &);

    // Disable assignment.
    PageFactory &operator=(const PageFactory &);
};

} // End Flexbook namespace.

#endif // PAGEFACTORY_H

