//
// Filename: pagedice.cpp
//
// Flexbook page for page A2.
//

#include "pagedice.h"
#include "pageoled.h"
#include "hal.h"
#include "mcp23s17.h"

#include "log.h"

#include <iostream>

namespace Flexbook {

PageDice::PageDice()
: pageoled()
{
    Log("Creating PageDice");
}

PageDice::~PageDice()
{
    Log("Deleting PageDice");
}

uint8_t PageDice::DicePoll()
{
    DigitalIn dice_D(p23);
    DigitalIn dice_C(p24);
    DigitalIn dice_B(p25);
    uint8_t dicevalue = 0;
    if (dice_D) dicevalue =+ 1;
    if (dice_C) dicevalue =+ 2;
    if (dice_B) dicevalue =+ 4;
    return(dicevalue);
}


void PageDice::HandlePageActions()
{
    DigitalOut led1(LED1); DigitalOut led2(LED2);
    int dicenr = 1;
    if (HAL::GetMCP23S17().Read(HAL::GPIOA) == 0xF7)
    {
        led1 = 1;
        while (HAL::GetMCP23S17().Read(HAL::GPIOA) == 0xF7)
        {
            //write the value of dicenr to the digit on OLED
            pageoled.Write(pageoled.Translate(0,0,0,0,0,dicenr));
            //pageoled.DiceRoll(dicenr);
            wait(0.1);
            dicenr = dicenr + 1;
            if (dicenr == 7) dicenr = 1;
        }
        led1=0;
        //finger is now removed from the touch electrode
        led2=1;
        for (int i=30; i>0; i--)
        {
            //write the value of dicenr to the digit on OLED
            pageoled.Write(pageoled.Translate(0,0,0,0,0,dicenr));
            //pageoled.DiceRoll(dicenr);
            wait(4/(i+3));      //change count slow-down formula to suit
        }
        led2 = 0;
    }
}

/*
void PageDice::HandleDice()
{
    DigitalOut led1(LED1); DigitalOut led2(LED2);
    int dicenr = 1;
    //sensordata.dice = 1;
    if (HAL::GetMCP23S17().Read(HAL::GPIOA) == 0xF7)
    {
        led1 = 1;
        while (HAL::GetMCP23S17().Read(HAL::GPIOA) == 0xF7)
        {
            //write the value of dicenr to the digit on OLED
            //sensordata.dice = dicenr;
            pageoled.Write(pageoled.Translate(0,0,0,0,0,dicenr));
            wait(0.05);
            dicenr = dicenr + 1;
            if (dicenr == 7) dicenr = 1;
        }
        led1=0;
        //finger is now removed from the touch electrode
        led2=1;
        for (int i=10; i>0; i--)
        {
            //write the value of dicenr to the digit on OLED
            dicenr = dicenr + 1;
            if (dicenr == 7) dicenr = 1;
            //sensordata.dice = dicenr;
            pageoled.Write(pageoled.Translate(0,0,0,0,0,dicenr));
            wait(4/(i+1));      //change count slow-down formula to suit
            //wait(0.3);
        }
        led2 = 0;
        //sensordata.dice = dicenr;
    }
}
*/

} // End Flexbook namespace.



