//
// Filename: main.cpp
//
// Flexbook startup.
//

#include "book.h"
#include "bookmonitor.h"
#include "eink.h"
#include "hal.h"
#include "log.h"
#include "pagefactory.h"
#include <string>

using namespace Flexbook;

#include "mbed.h"
#include "SDFileSystem.h"

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
DigitalOut buzz(p21, 0);
//define all pins connected to companion PCBs as DigitalIn (high impedence)
DigitalIn pin9(p9);
DigitalIn pin10(p10);
DigitalIn pin11(p11);
DigitalIn pin12(p12);
DigitalIn pin13(p13);
DigitalIn pin14(p14);
DigitalIn pin15(p15);
DigitalIn pin16(p16);
DigitalIn pin17(p17);
DigitalIn pin18(p18);
DigitalIn pin23(p23);
DigitalIn pin24(p24);
DigitalIn pin25(p25);
DigitalIn pin26(p26);
DigitalIn pin27(p27);
DigitalIn pin28(p28);
DigitalIn pin29(p29);
DigitalIn pin30(p30);

// MicroSD            mbed
//   CS  o-------------o 8    (DigitalOut cs)
//   DI  o-------------o 5    (SPI mosi)
//   VCC o-------------o VOUT
//   SCK o-------------o 7    (SPI sclk)
//   GND o-------------o GND  
//   DO  o-------------o 6    (SPI miso)
//   CD  o



SDFileSystem sd(p5, p6, p7, p8, "sd"); // the pinout on the Flexboard board

void SDtest()
{
    printf("\nSD card: ");

    FILE *fp1 = fopen("/sd/sdtest.txt", "w");
    if(fp1 == NULL) {
        error("Could not open file for write\n");
    }
    if(fprintf(fp1, "Hello SD Card\n") != 14)
        error("Could not write data\n");
    fclose(fp1);

    FILE *fp2 = fopen("/sd/sdtest.txt", "r");
    if(fp2 == NULL) {
        error("Could not open file for read\n");
    }
    char data[64];
    data[0] = 0;
    if(fgets(data, sizeof(data), fp2) == NULL)
        error("Could not read data\n");
    fclose(fp2);

    printf("Ok\n");
}
/*
//function to count number of eligible words in the dictionary file
int NumDictWords()
{
    FILE *fp1 = fopen("/sd/hangdict.txt", "r");
    if (fp1 == NULL) {
        printf("Could not open hangdict.txt\n");
        }
        else {
            printf("hangdict.txt opened\n");
            }
    int wordcount = 0;
    int wordlength = 0;
    int ch;
    while (EOF != (ch = getc(fp1))) {
        // check if character is an LF. It the word on that line is the right length, increment word counter
        if (ch == 10) {
            if ((wordlength > 7) && (wordlength < 15)) {
                wordcount = wordcount + 1;
                }
                wordlength = 0;
            }
        else {
            // if the character is not an LF, increment character count
            wordlength = wordlength + 1;
            }
        }
    fclose(fp1);
    printf("Word count: %u\n", wordcount);
    return wordcount;
}

// ReturnWord is used to pick an indexed word from the hangdict.txt file 
int ReturnWord(int wordindex, char* word2guess)
{
    FILE *fp1 = fopen("/sd/hangdict.txt", "r");
    printf("Returning word %u: ", wordindex);
    for (int i = 0; i < wordindex; i++) {
        fgets(word2guess, 24, fp1);
        while ((strlen(word2guess) < 6) || (strlen(word2guess) > 12)) {
            fgets(word2guess, 24, fp1);
        }
    }
    printf("%s", word2guess);
    fclose(fp1);
    return (strlen(word2guess)-2);
}
*/

int main()
{
    HAL::Initialise();
    srand(time(NULL));
    Flexbook::PageFactory factory;                              // Page creator
    Flexbook::Book book(factory);                               // Page container
    Flexbook::BookMonitor monitor(book);                        // Page turn monitor
   
    //This section to test individual pages:
    //book.PageChange(Flexbook::PageType_PageFlexEnable);
    //book.PageChange(Flexbook::PageType_PageSensor);
    //book.PageChange(Flexbook::PageType_PageTouch);
    //etc...

    //DisplayHardwareSettings();

    //Log("White screen in main");
    //WriteColour(Get_epdc(), 0xff);//PL_WHITE);

    /*
    wait(4);
    Log("Write partial image in main");
    WritePartImage("/myfile.pgm", 60, 30, 60, 30, 100, 100);

    wait(4);
    Log("Update display in main");
    UpdateDisplay();

    Log("Write partial image 2");
    WritePartImage("/myfile.pgm", 160, 100, 160, 100, 50, 200);

    wait(4);
    UpdateDisplay();
    book.PageChange(Flexbook::PageType_PageTouch);
    */
    
    Log("starting main loop");
    while(true)                                                 // Main loop
    {
        monitor.CheckForPageChange();                           // Creates/destructs pages based on sensor touches
                                                                // In this version only PageSensor or PageTouch can be active
                                                                // Other pages are created as dependents
        book.HandleActions();                                   // Performs actions for the currently active page
    }
}
