//
// Filename: i2c_utils.cpp
//
// I2C utilities.
//

#include "i2c_utils.h"

uint16_t GetAddressRangeEnd(uint16_t bits)
{
    uint16_t end = 0;
    switch(bits)
    {
        case 7:
            end = 0x80;
            break;

        case 10:
            end = 0x400;
            break;

        default:
            printf("Bad address range\n");
    }
    
    return end;
}

void I2C_Scan(I2C &i2c, uint16_t bits)
{
    printf("Scanning I2C...\n");

    const uint16_t end = GetAddressRangeEnd(bits);

    char data;
    for(uint16_t address = 0; address < end; address++)
    {
        if(i2c.read(address << 1, &data, 1) == 0)
            printf("Address 0x%02x found\n", address);
    }
}
