//
// Filename: hangman.h
//
// Class for the hangman game played on pagesensor and pageflexenable.
//

// include guards

#include <memory>
#include "mbed.h"
#include "log.h"
#include "eink.h"
//include more files, e.g. where eink display is changed, and to read from SD card

namespace Flexbook
{

class HangmanGame
{
public:
    // Constructor needs to be explicit.
    explicit HangmanGame();
    
    // Destructor
    ~HangmanGame();
    
    // Routine to determine how to move the cursor after electrode touch
    char MoveCursor(const bool alphabet[27],const char buttonnumber, char oldpos);
    
    // Routine to run after confirming selection of a position in the alphabet matrix
    bool SelectLetter(const char letterpos, const char word2guess[14], const char wordlength, char* guessed[14], char hangmanstate);
    
    // Game status indicator
    bool finished;
    // Alphabet matrix is 3 rows with 9 columns. A..M,?,N..Z
    // Currently selected and previous position on the alphabet matrix
    char currentpos;
    char oldpos;
    
    // Status indicator for each letter on the alphabet matrix, already used or not?
    bool alphabet[27];
    
private:
    // Word to be guessed, word guessed so far
    char word[14];
    char guessed[14];
    
    // Number of letters in word to be guessed (8-14)
    char wordlength;
          
    // Number of wrong guesses, equals number of elements of hanging man drawn
    char hangstage;
       
    // Function returning x-position on the display of "letterpos" in alphabet matrix
    int Xpos(const char letterpos);
    
    // Function returning y-position on the display of "letterpos" in alphabet matrix
    int Ypos(const char letterpos);
    
    // Routine to redraw the hanging man
    void DrawMan(const char manstate);
    
    // Routine to redraw the alphabet matrix after a cursor move
    void RedrawAlphabet(const char newpos, const char oldpos, const bool alphabet[27]);
    
    // Routine to (re)draw the current word guess, using question marks for unknown characters
    void DrawWord(const char guessed[14], const char wordlength);
    
    // Routine to pick new word to be guessed
    char ReturnWord(char &word2guess);
    
    // routine to count number of words in hangdict file
    int NumDictWords ();
};

}
