//
// Filename: book.h
//
// Container for Flexbook pages.
//

// include guards
#ifndef BOOK_H
#define BOOK_H

#include "page.h"

namespace Flexbook
{

class Page;
class PageFactory;

typedef int PageType;

class Book
{
public:
    // Constructor needs to be explicit.
    explicit Book(PageFactory &factory);

    // Destructor.
    ~Book();

    // Page change notification.
    void PageChange(PageType type);

    // Return the type of the currently active page.
    PageType GetPageType() const;

    void HandleActions();

private:
    // Disable the copy constructor.
    Book(const Book &);

    // Disable assignment.
    Book &operator=(const Book &);

    PageFactory &factory;
    PageType    pagetype;

    BookPage page;
};

} // End Flexbook namespace.

#endif // BOOK_H

