//
// Filename: pagetouch.cpp
//
// Flexbook page for page A4.
//

#include "pagetouch.h"
#include "pageflexenable.h"

#include "eink.h"

#include "log.h"

#include <iostream>

namespace Flexbook {

PageTouch::PageTouch()
: pageflexenable(),
  hangmangame(),
  i2c(p28, p27), irq(p26),
  at42qt2120(i2c), key(0)
{
    Log("Creating PageTouch");
    

    at42qt2120.SetSliderOptions(HAL::WHEEL);

    at42qt2120.SetKeyControl(1, false, 2, false, true);
    at42qt2120.SetKeyControl(2, false, 2, false, true);
    at42qt2120.SetKeyControl(3, false, 2, false, true);

    at42qt2120.SetKeyControl(5, false, 1, false, true);
    at42qt2120.SetKeyControl(6, false, 1, false, true);
    at42qt2120.SetKeyControl(7, false, 1, false, true);
    at42qt2120.SetKeyControl(8, false, 1, false, true);
    at42qt2120.SetKeyControl(9, false, 1, false, true);
    at42qt2120.SetKeyControl(10, false, 1, false, true);

    irq.fall(callback(this, &Flexbook::PageTouch::TouchChange));
    newtouch = false;
    imgnumber = 0;

#ifdef VERBOSE
    for(int n = 0; n < 99; n++)
        printf("Register %03d %02x\n", n, at42qt2120.Read((HAL::REG_AT42QT2120) n));
#endif
}

PageTouch::~PageTouch()
{
    Log("Deleting PageTouch");

    irq.disable_irq();
}

void PageTouch::TouchChange()
{
    static volatile bool inirq = false;
    if(!inirq)
    {
        inirq = true;
        Page::ShortBeep();

        HAL::AT42QT2120::Status status;
        if(at42qt2120.ReadStatus(status))
        {
            if(status.keyschanged)
            {
                key = status.keys;
                
                if(status.keys & HAL::KEY0)
                    Log("Key 0");
                if(status.keys & HAL::KEY1)
                    Log("Key 1");
                if(status.keys & HAL::KEY2)
                    Log("Key 2");
                if(status.keys & HAL::KEY3)
                    Log("Key 3");
                if(status.keys & HAL::KEY4)
                    Log("Key 4");
                if(status.keys & HAL::KEY5)
                    Log("Key 5");
                if(status.keys & HAL::KEY6)
                {
                    Log("Key 6");
                    hangmangame.currentpos = hangmangame.MoveCursor(hangmangame.alphabet, 6, hangmangame.oldpos);
                    Log("back in pagetouch");
                }
                if(status.keys & HAL::KEY7)
                {
                    Log("Key 7");
                    hangmangame.currentpos = hangmangame.MoveCursor(hangmangame.alphabet, 7, hangmangame.oldpos);
                }
                if(status.keys & HAL::KEY8)
                {
                    Log("Key 8");
                }
                if(status.keys & HAL::KEY9)
                {
                    Log("Key 9");
                    hangmangame.currentpos = hangmangame.MoveCursor(hangmangame.alphabet, 9, hangmangame.oldpos);
                }
                if(status.keys & HAL::KEY10)
                {
                    Log("Key 10");
                    hangmangame.currentpos = hangmangame.MoveCursor(hangmangame.alphabet, 10, hangmangame.oldpos);
                }
                if(status.keys & HAL::KEY11)
                    Log("Key 11");
            }
            if(status.sliderchanged)
            {
                printf("Slider/wheel: %x\n", status.slider);
            }
        }

        inirq = false;
    }
}

int PageTouch::GetKey()
{
    int outkey = key;
    key = 0;
    return outkey;
}

/*
void PageTouch::HandlePageActions()
{
    if (newtouch)
    {
        printf("%i \n", imgnumber);
        pageflexenable.numimage = imgnumber;
        //pageflexenable.UpdateImage();
        newtouch = false;
    }
}
*/
} // End Flexbook namespace.



