//
// Filename: pagedoled.h
//
// Flexbook page for page A3.
//

// include guards
#ifndef PAGEOLED_H
#define PAGEOLED_H

#include "page.h"

#include "mbed.h"

namespace Flexbook
{

struct SensorData;

class PageOLED : public Page
{
public:
    // Constructor needs to be explicit.
    explicit PageOLED();

    // Destructor.
    virtual ~PageOLED();
    
    // Write data to OLED.
    void Write(uint64_t writedata);
    
    uint64_t Translate(char b1, char b2, char b3, char b4, char b5, char d1);

    void SensorPoll(const SensorData &sensordata);
    void DiceRoll(const int dicenr);
    
    virtual void HandlePageActions ();

private:
    // Disable the copy constructor.
    PageOLED(const PageOLED &);

    // Disable assignment.
    PageOLED &operator=(const PageOLED &);
    
    DigitalOut data;
    DigitalOut clock;
    DigitalOut strobe;
    DigitalOut enable;
};

} // End Flexbook namespace.

#endif // PAGEOLED_H

