//
// Filename: mcp23s17.cpp
//
// Flexbook Hardware Abstraction Layer.
//

#include "mcp23s17.h"

namespace HAL {

MCP23S17::MCP23S17(int addressin, SPI &spiin, DigitalOut &csin)
: address(addressin), spi(spiin), cs(csin)
{
    spi.format(8, 1);
}

int MCP23S17::Read(REG_MCP23S17 reg)
{
    cs = 0;
    spi.write(address | 0x41);
    spi.write(reg);
    int data = spi.write(0x00); // Write dummy value to read.
    cs = 1;
    
    return data;
}

void MCP23S17::Write(REG_MCP23S17 reg, int value)
{
    cs = 0;
    spi.write(address | 0x40);
    spi.write(reg);
    spi.write(value);
    cs = 1;
}

} // End HAL namespace.

