#include "mbed.h"
#include "MTSSerial.h"
#include "Wifi.h"
using namespace mts;

/* This example shows how to do a basic connectivity test using
* the MTS Wifi shield board. You will need to change the network
* SSID and security key, unless you are at the 2014 AT&T hackathon
* where you can use the defaults below.
*/

int main()
{
    //Set the network parameters
    std::string ssid = "belkin54g";
    std::string securityKey = "hackathon";
    Wifi::SecurityType securityType = Wifi::WPA;

    //Wait for wifi module to boot up
    for (int i = 10; i >= 0; i = i - 2) {
        wait(2);
        printf("Waiting %d seconds...\n\r", i);
    }

    //Setup serial interface to WiFi module
    MTSSerial* serial = new MTSSerial(PTD3, PTD2, 256, 256);
    serial->baud(9600);

    //Setup Wifi class
    Wifi* wifi = Wifi::getInstance();
    printf("Init: %s\n\r", wifi->init(serial) ? "SUCCESS" : "FAILURE");

    //Setup and check connection
    printf("Set Network: %s\n\r", getCodeNames(wifi->setNetwork(ssid, securityType, securityKey)).c_str());
    printf("Set DHCP: %s\n\r", getCodeNames(wifi->setDeviceIP("DHCP")).c_str());
    while (! wifi->connect()) {
        printf("Connect: Failure\r\n");
        wait(1);
    }
    printf("Connect: Success\r\n");
    printf("Is Connected: %s\n\r", wifi->isConnected() ? "True" : "False");

    //Ping
    while (true) {
        printf("Ping Server: %s\n\r", wifi->ping("8.8.8.8") ? "Success" : "Failed");
        wait(3);
    }
}
