#include "mbed.h"

InterruptIn _BlueButton(USER_BUTTON);
DigitalOut  _led1(LED1); 

class myComp {
public:

Thread      _ISRthread;
EventQueue  _ISRqueue;
int         _cnt;
 
void ThreadBodyFunc () {
      printf ("ThreadBodyFunc tid: %x activated\n\r", (unsigned int)_ISRthread.gettid());
    _led1 = !_led1;
    _cnt++;
}
void start() {
      printf ("starting tid: %x ...\n\r", (unsigned int)_ISRthread.gettid());   
    _cnt=0;
   _ISRthread.start(callback(&_ISRqueue, &EventQueue::dispatch_forever));   
   _ISRthread.set_priority(osPriorityRealtime);   // after having called break_dispatch it FAILS with "Thread 00000000 error -4: Parameter error"
   _BlueButton.fall(_ISRqueue.event(this, &myComp::ThreadBodyFunc )); 

}
void stop() {
    printf ("Stopping th...\n\r");  
   _cnt=0;    
   _ISRqueue.break_dispatch();
   _ISRthread.terminate();
   _ISRthread.join();
   printf ("... th joined\n\r"); 
}
};

// main() runs in its own thread in the OS
// pushing the BlueButton 4 times trigger the break_dispatch

int main() {
 myComp comp;   
    printf ("Main started\n\r");
    comp.start(); 
    
    while (1) {
         Thread::yield();
         if (comp._cnt>3) {
            comp.stop();
            Thread::yield();
            comp.start();     
         }
    }   
}

