#include "mbed.h"
#include "tsi_sensor.h"
#include <stdio.h>
#include <stdlib.h>

// Definicion de estados
enum{
    PlayTime = 0, // 0
    Loss, // 1
    Win, // 2
};

Ticker tick;    //Definición del ticker
TSIAnalogSlider tsi(ELEC0, ELEC1, 40); // LectorTSI
Serial pc(USBTX,USBRX,115200);  //Inicializacion Comunicacion Serial

//Salidas KL25
DigitalOut ledred(PTB18);
DigitalOut ledgreen(PTB19);

DigitalOut disp_a(PTC7);
DigitalOut disp_b(PTC0);
DigitalOut disp_c(PTC3);
DigitalOut disp_d(PTC4);
DigitalOut disp_e(PTC5);
DigitalOut disp_f(PTC6);
DigitalOut disp_g(PTC10);
DigitalOut disp_common1(PTC1);
DigitalOut disp_common2(PTC2);

BusIn mywires(PTE30,PTE29,PTE23,PTE22); // Vector de entradas de los cables 
/*
 green(PTE30);
 yellow(PTE29);
 orange(PTE23);
 black(PTE22); 
*/
//Variables
unsigned char numdisp=0, num_display[10] = {0b1111110,0b0110000,0b1101101,0b1111001,0b0110011,0b1011011,0b1011111,0b1110000,0b1111111,0b1111011};  
unsigned int i=0, aux=0, clk=0, clkdisp=0, pos=0, t=0, srand_t=0, num, wires[4], defusing=0;

//Maquina de estados
void InputPulso(int Indice);

// Prototipos
void dispnum(int num);

// Funcion del ticker
void SystickHandler(void)
{
    t++;
    clk++;
    srand_t++;
    //Multiplexacion de los displays
    clkdisp++;
     if(clkdisp == 10){
        if(pos == 0){
            disp_common1=1;
            disp_common2=0;
            pos = 1;
        }
        else{
            disp_common1=0;
            disp_common2=1;
            pos = 0;
        }
        clkdisp=0;  
    }
}

int main(void) {
    
    //Inicializaciones
    mywires[0].mode(PullUp);
    mywires[1].mode(PullUp);
    mywires[2].mode(PullUp);
    mywires[3].mode(PullUp);
    tick.attach(&SystickHandler, 0.001); // Base Tiempo 1mS
    
    pc.printf("\n\nFLORES - VILLANI 6B Tec Prof: MATI MARFISI\nDesactivar la bomba!!!!\n\n");
    
    pc.printf("\nPresione el TSI para empezar a jugar\n");
    
    for(;;) {   // Bucle Infinito  
        InputPulso(0);
    }
}


void InputPulso(int Indice)
{
    static int state = PlayTime, stateplay = 0; // Estado Inicial   
    switch (state){
        case PlayTime:
            switch (stateplay){
                case 0:
                    ledred=1;
                    ledgreen=1;
                    disp_a = 0;
                    disp_b = 0;
                    disp_c = 0;
                    disp_d = 0;
                    disp_e = 0;
                    disp_f = 0;
                    disp_g = 0;
                   if(clk < 1000){
                        disp_g=1;
                        ledred=0;
                    }
                    if(clk > 1000){
                        disp_g=0;
                        ledred=1;
                    }
                    if(clk > 2000){
                        // If que se fija si estan conectados los cables a GND
                        if(mywires[0].read() == false && mywires[1].read() == false && mywires[2].read() == false && mywires[3].read() == false){
                            pc.printf("\nTodos los cables conectados\nBuena Suerte!!!\n\n");
                            stateplay = 1;
                            clk=0;
                            num=51;
                            
                            //Randomizer 4 numeros
                            while(true){
                                srand(srand_t);
                                wires[0] = rand()%4; wires[1] = rand()%4; wires[2] = rand()%4; wires[3] = rand()%4;
                                if(wires[0] == wires[1] || wires[0] == wires[2] || wires[0] == wires[3] || wires[1] == wires[0] || wires[1] == wires[2] || wires[1] == wires[3] ||
                                   wires[2] == wires[0] || wires[2] == wires[3] || wires[2] == wires[1] || wires[3] == wires[2] || wires[3] == wires[0] || wires[3] == wires[1])
                                   continue;
                                else{
                                    for(i=0;i<4;i++){
                                        if(wires[i]==0)
                                            pc.printf("Desconecte el cable VERDE\n");
                                        if(wires[i]==1)
                                            pc.printf("Desconecte el cable AMARILLO\n");          
                                        if(wires[i]==2)
                                            pc.printf("Desconecte el cable NARANJA\n");
                                        if(wires[i]==3)
                                            pc.printf("Desconecte el cable NEGRO\n");
                                    }
                                    break;
                                }   
                            }
                            
                        }
                        else{
                            pc.printf("Conecte los cables al KL25 para jugar\n");
                            clk=0;
                        }
                    }
                break;
                case 1:
                    dispnum(num);
                    //If cada 1 seg cuenta atras
                    if(t>1000){
                        num--;
                        t=0;
                    }
                    
                    switch (defusing){
                        case 0:
                            if(mywires[wires[0]].read() == true){ //1er Cable Desconectado
                                defusing++;
                                clk=0;
                            } 
                            //If se fija si tuviste un error
                            else if(mywires[wires[1]].read() == true || mywires[wires[2]].read() == true || mywires[wires[3]].read() == true){
                                state = Loss;
                                stateplay = 0;
                                defusing = 0;
                                clk=0;
                                pc.printf("\nPerdiste... BOOOOOOOOOOOOM\n");
                                pc.printf("\nPresione el TSI para volver a jugar\n\n");
                            }
                        break;
                        case 1:
                            if(mywires[wires[1]].read() == true){
                                defusing++;
                                clk=0;
                            }
                            //If se fija si tuviste un error
                            else if(mywires[wires[2]].read() == true || mywires[wires[3]].read() == true || (mywires[wires[0]].read() == false && clk > 100)){
                                state = Loss;
                                stateplay = 0;
                                defusing = 0;
                                clk=0;
                                pc.printf("\nPerdiste... mamitaaa posho\n");
                                pc.printf("\nPresione el TSI para volver a jugar\n\n");
                            }
                        break;
                        case 2:
                            if(mywires[wires[2]].read() == true){
                                defusing++;
                                clk=0;
                            }
                            //If se fija si tuviste un error
                            else if(mywires[wires[3]].read() == true || (mywires[wires[0]].read() == false && clk > 100) || (mywires[wires[1]].read() == false && clk > 100)){
                                state = Loss;
                                stateplay = 0;
                                defusing = 0;
                                clk=0;
                                pc.printf("\nPerdiste... ayyy\n");
                                pc.printf("\nPresione el TSI para volver a jugar\n\n");
                            }
                        break;
                        case 3:
                            if(mywires[wires[3]].read() == true){
                                defusing=0;
                                state = Win;
                                stateplay = 0;
                                pc.printf("\nFELICIDADES... CAMPEON!!!\n");
                                pc.printf("\nPresione el TSI para volver a jugar\n\n");
                            }
                            //If se fija si tuviste un error
                            else if((mywires[wires[0]].read() == false && clk > 100) || (mywires[wires[1]].read() == false && clk > 100) || (mywires[wires[2]].read() == false && clk > 100)){
                                state = Loss;
                                stateplay = 0;
                                defusing = 0;
                                clk=0;
                                pc.printf("\nPerdiste... como vas a conectar devuelta los cables flaco???\n");
                                pc.printf("\nPresione el TSI para volver a jugar\n");
                            }
                        break;
                    }
                    // If que controla cuanto el contador llegue a 0, pierdas automaticamente
                    if(num == 0){
                        state = Loss;
                        stateplay = 0;
                        pc.printf("\nPerdiste...  NT\n");
                        pc.printf("\nPresione el TSI para volver a jugar\n\n");
                    }
                break;
            }    
        break;
        case Win:
            ledgreen = 0;
            ledred = 1;
            //Parpadeo del display
            if(clk <= 500)
                dispnum(num);
            if(clk > 500){
                disp_a = 0;
                disp_b = 0;
                disp_c = 0;
                disp_d = 0;
                disp_e = 0;
                disp_f = 0;
                disp_g = 0;
            }
            if(clk > 1000)
                clk=0;
            
            //TSI para volver a jugar
            if(tsi.readPercentage() > 0.1 && clk > 100){
                t=0;
                clk=0;
                state = PlayTime;
            }
        break;
        case Loss:
            ledred = 0;
            ledgreen = 1;
            //Parpadeo del display
            if(clk <= 500 )
                dispnum(num);
            if(clk > 500 ){
                disp_a = 0;
                disp_b = 0;
                disp_c = 0;
                disp_d = 0;
                disp_e = 0;
                disp_f = 0;
                disp_g = 0;
            }
            if(clk > 1000)
                clk=0;
                
            //TSI para volver a jugar
            if(tsi.readPercentage() > 0.1 && clk > 100){
                t=0;
                clk=0;
                state = PlayTime;
            }
        break;
        
    }
}


void dispnum(int num)
{
    //Multiplexacion
    if(pos == 0)
        numdisp=num/10;
    else
        numdisp=num%10;
    // Operaciones de bits
        if (num_display[numdisp] & 0b1000000)           
            disp_a = 1;                    
        else
            disp_a = 0;
        if (num_display[numdisp] & 0b0100000)
            disp_b = 1;
        else
            disp_b = 0;
        if (num_display[numdisp] & 0b0010000)
            disp_c = 1;
        else
            disp_c = 0;
        if (num_display[numdisp] & 0b0001000)
            disp_d = 1;
        else
            disp_d = 0;
        if (num_display[numdisp] & 0b0000100)
            disp_e = 1;
        else
            disp_e = 0;
        if (num_display[numdisp] & 0b0000010)
            disp_f = 1;
        else
            disp_f = 0;
        if (num_display[numdisp] & 0b0000001)
            disp_g = 1;
        else
            disp_g = 0;
}

