#include "mbed.h"

#define ERROR -1
int touchSense1(void);
int touchSense2(void);
int getTouch(void);
void hostError(void);
void touchError(void);
void runFunction(void);

DigitalOut myled1(LED1);
DigitalOut myled2(LED3);

AnalogIn input1(p20);
AnalogIn input2(p15);

DigitalIn charger1(p19);
DigitalIn charger2(p16);

DigitalOut ground1(p18);
DigitalOut ground2(p17);
Serial pc(USBTX, USBRX); // tx, rx

int gInd = 0;
int main() {
    pc.attach(runFunction);
    while(1) {
        if(gInd == 1)
        {
            pc.printf(" Reached back the main fun\n");
            gInd =0;
         }
        wait(0.2);
    }
}

void runFunction() {
    char A[1024],c='k';
    int len, i, t_bit, h_bit;
    gInd = 1;
    int err_set ;
   pc.printf(" Entering the reading loop\n");
       // if (pc.readable()) {
           i = 0;
            err_set = 0;
            while(c!='S' && pc.readable())
                c = pc.getc();
                
            while( (c != 'E') && pc.readable())
            {
                if(c != ' ')
                {
                    //if((c == '0') || (c=='1'))
                        A[i++] = c;
                        if((i>1) && (c!='0') &&(c!='1'))
                        {
                            err_set = 1;
                            hostError();
                            while(pc.readable()) //buffer out rest and return
                                c=pc.getc();
                            return;
                        }
                    
                }
             //   pc.printf("READING %c \n",c);
                c = pc.getc();
            }
            A[i] = c;
            A[i+1]='\0';
            while(pc.readable()) //buffer out rest.
                c=pc.getc();
           
             
            //pc.printf("DATA RECV : %s\n",A);
            len = strlen(A)-1; //to make it right offset
            if ((A[0]!='S') || (A[len] != 'E')) {
                hostError();
                return;
            }
            i = 1;
            while (i<len) {
                t_bit = getTouch();
                //pc.printf("\n MY TOKEN IS %c and touch is %d\n",A[i],t_bit);
                if (A[i] == '0')
                    h_bit = 0;
                else if (A[i] == '1')
                    h_bit = 1;
             
                if (t_bit != h_bit) {
                    touchError();
                    return;
                }
                i++;
            }
            pc.printf("MATCH\n");
        //}
        return;
}

int getTouch(void) {
    int sens;
    while (1) {

        sens = 0;
        if (touchSense1()) {
            wait_ms(5);
         while(touchSense1())
            {
            //    pc.printf("In touchsense1\n");
                sens = 1;
                wait_ms(100);
            }
            if(sens)
                return 0;   
        }

        if (touchSense2()) {
            wait_ms(5);
            while(touchSense2())
            {
          //      pc.printf("In touchsense2\n");
                sens = 1;
                wait_ms(100);
             }
             if(sens)
                return 1;
        }     
    }
}

int touchSense1(void) {
    float sample;
    ground1 = 0;
    charger1.mode(PullUp);
    charger1.mode(PullNone);
    sample=input1.read();
    if (sample < 0.3) {
        return 1;
    } else {
        return 0;
    }
}

int touchSense2(void) {
    float sample;
    ground2 = 0;
    charger2.mode(PullUp);
    charger2.mode(PullNone);
    sample=input2.read();
    if (sample < 0.3) {
        return 1;
    } else {
        return 0;
    }
}

void hostError() {
    pc.printf("HOST ERROR");
}
void touchError() {
    pc.printf("TOUCH ERROR");
}