#include "mbed.h"

#define numsamples 1
#define ERROR -1
int touchSense1(void);
int touchSense2(void);
int getTouch(void);
void hostError(void);
void touchError(void);
DigitalOut myled1(LED1);
DigitalOut myled2(LED3);

AnalogIn input1(p20);
AnalogIn input2(p15);

DigitalIn charger1(p19);
DigitalIn charger2(p16);

DigitalOut ground1(p18);
DigitalOut ground2(p17);
Serial pc(USBTX, USBRX); // tx, rx
#define DEBUG 1
int main() {
    char A[1024],c;
    int len, i, t_bit, h_bit;
    while (1) {
START:

           c = 'k'; //random no.
           i = 0;
          if(pc.readable())
          {  
#ifdef DEBUG
    pc.printf("DBG: Got a  Host String:\n");
#endif
            while(pc.readable() && c!='S')
                c = pc.getc();
                
            while(pc.readable() && (c != 'E'))
            {
                if(c != ' ')
                {
                    //if((c == '0') || (c=='1'))
                        A[i++] = c;
                        if((i>1) && (c!='0') &&(c!='1'))
                        {
                            hostError();
                            while(pc.readable())
                                c=pc.getc();
                            goto START;
                         }
                    
                }
             //   pc.printf("READING %c \n",c);
                c = pc.getc();
            }
            A[i] = c;
            A[i+1]='\0';
            while(pc.readable()) //bufferout rest;
                c=pc.getc();
            pc.printf("DATA RECV : %s\n",A);
            len = strlen(A)-1; //to make it right offset
            if ((A[0]!='S') || (A[len] != 'E')) {
                hostError();
                goto START;
            }
            i = 1;
            while (i<len) {
                t_bit = getTouch();
                pc.printf("\n MY TOKEN IS %c and touch is %d\n",A[i],t_bit);
                if (A[i] == '0')
                    h_bit = 0;
                else if (A[i] == '1')
                    h_bit = 1;
             
                if (t_bit != h_bit) {
                    touchError();
                    goto START;
                }
                i++;
            }
            pc.printf("MATCH\n");
         }
        wait(0.001);
    }
}
int getTouch(void) {
    int sens;
    while (1) {

        sens = 0;
        if (touchSense1()) {
            wait_ms(5);
         while(touchSense1())
            {
            //    pc.printf("In touchsense1\n");
                sens = 1;
                wait_ms(100);
            }
            if(sens)
                return 0;   
        }

        if (touchSense2()) {
            wait_ms(5);
            while(touchSense2())
            {
          //      pc.printf("In touchsense2\n");
                sens = 1;
                wait_ms(100);
             }
             if(sens)
                return 1;
        }     
    }
}

int touchSense1(void) {
    float sample;
    ground1 = 0;
    charger1.mode(PullUp);
    charger1.mode(PullNone);
    sample=input1.read();
    if (sample < 0.3) {
        return 1;
    } else {
        return 0;
    }
}

int touchSense2(void) {
    float sample;
    ground2 = 0;
    charger2.mode(PullUp);
    charger2.mode(PullNone);
    sample=input2.read();
    if (sample < 0.3) {
        return 1;
    } else {
        return 0;
    }
}

void hostError() {
    pc.printf("HOST ERROR");
}
void touchError() {
    pc.printf("TOUCH ERROR");
}