#ifndef _PQUEUE_H_
#define _PQUEUE_H_

typedef struct prioQueueEle {
    timeval t;
    void (*foo)(void);
    int sched;
    struct prioQueueEle *next;
}qEle;
typedef struct prioQueue {
    int numEle;
    qEle *head;

}pQueue;



int enqueue(pQueue *xP, timeval t, void (*schedFunc)(void)) {
    if (xP->numEle == QUEUE_MAX)
        return 0; //ERROR reached max .

    xP->numEle++;
    qEle *newEle = (qEle*)malloc(sizeof(qEle));
    newEle->t.tv_sec = t.tv_sec;
    newEle->t.tv_usec = t.tv_usec;
    newEle->foo = schedFunc;
    newEle->sched = 0;
    newEle->next = NULL;
    if (xP->head == NULL) { //first ele;
        xP->head = newEle;
        return 1;
    } else {
        if ((xP->head->t.tv_sec > t.tv_sec) ||
                ((xP->head->t.tv_sec == t.tv_sec ) && (xP->head->t.tv_usec > t.tv_usec))  ) {
            newEle->next = xP->head;
            xP->head = newEle;
        
            return 1;
        } else if (xP->head->next == NULL) {
            xP->head->next = newEle;
            return 1;
        }
    }
    qEle *e = xP->head;
    while (e->next->next !=NULL) {
        if ((e->next->t.tv_sec > t.tv_sec) ||
                ((e->next->t.tv_sec == t.tv_sec) && (e->next->t.tv_usec > t.tv_usec))  ) {
            newEle->next = e->next;
            e->next = newEle;
            return 1;
        }
        e= e->next;
    }
    e->next->next = newEle;
    return 1;
}




qEle* pop(pQueue *xP) {
    qEle *p = xP->head;
    xP->head = p->next;
    xP->numEle--;
    return p;
//    free(p);
}

#endif