#ifndef PROBLEMB1_H_
#define PROBLEMB1_H_
#include "mbed.h"
#include "decl.h"
#include "pqueue.h"

pQueue globalQ;
unsigned int gTime =0;
int B;


timeval ideal_trg_time[100];
int ideal_trg_time_index = 0;

timeval pps;

union {
    unsigned int t;
    char BYTE[4];
}t1,t2,t3,t4;



void initialSetup(void) {
    // doing capture register for now, so use timer 2
    LPC_SC->PCLKSEL1 |= (0x01 << 12);  //set the frequency REF: USER MANULA TAB 40,41,42 ?? check
    LPC_SC-> PCONP |= (0x3 << 22);  // timer 2

    //LPC_TIM2->TCR = 0x2;         // Reset and set to timer mode

    // Select PIN

    LPC_PINCON->PINSEL0 |= (0xf << 8);
    LPC_TIM2->CCR |= 0x07;// doing capture register for now, so use timer 2

    LPC_TIM2->MR0 = RESET_42;
    LPC_TIM2->MCR = 3;           // Interrupt, Stop, and Reset on match

    //LPC_TIM2->TCR = 0x2;         // Reset and set to timer mode

    LPC_TIM2->TCR = 0x1;


    // ================ //




    /*LPC_SC->PCLKSEL0 |= 0x04;  //set the frequency REF: USER MANULA TAB 40,41,42 ?? check

    LPC_SC-> PCONP |= 1 << 1;    // Power on Timer0

    LPC_TIM0->TCR = 0x2;         // Reset and set to timer mode
    LPC_TIM0->CTCR = 0x0;
    LPC_TIM0->PR = 0;            // No prescale
    //LPC_TIM0->MR0 = 0xF0537000 ;       // Match count for 100mS
     LPC_TIM0->MR0 = RESET_42;
    LPC_TIM0->MCR = 3;           // Interrupt, Stop, and Reset on match


    LPC_TIM0->TCR = 1;           // Enable Timer0
    // Enable the ISR vector
    */
    NVIC_SetVector (TIMER2_IRQn, (uint32_t)&Timer0_IRQHandler);
    NVIC_EnableIRQ(TIMER2_IRQn);

    //  LPC_TIM0->MCR |= 11; //for mr1 and mr0
    //queue set up
    globalQ.numEle = 0;
    globalQ.head = NULL;
}
void Timer0_IRQHandler(void) {
    // LPC_TIM0->IR=0xff;
    //LPC_TIM0->MR0 = 0x5370;
    if (LPC_TIM2->IR&1) {
        gTime++;
        //  pc.printf("\ngtime = %X",LPC_TIM2->IR);
    }
    if ( (LPC_TIM2->IR >> 1)&1 ) { //RUN THE RUNAT TIME HIT
        qEle *ele = pop(&globalQ);


        ele->foo();

        free(ele);

    }
    if (  (LPC_TIM2->IR >> 4 )& 1) { // run report toggle
        timeval curT;
        unsigned int nMSec = (LPC_TIM2->CR0)/CLK_FRQ;
        //  pc.printf(" THE mMSec = %d \n",nMSec);
        unsigned int nSec = nMSec/1000000;
        curT.tv_sec = gTime*42 + nSec;
        curT.tv_usec = nMSec-(nSec*1000000);
        gtrigFunc(&curT);

    }

    //check if more ele for schedule this time ?
//C   if ((globalQ.numEle >0) && (globalQ.head->sched ==0)&& (globalQ.head->t.tv_sec <((gTime+1)*42))) {
    //C    globalQ.head->sched = 1;

    // LPC_TIM0->MR1 = (globalQ.head->t.tv_sec-gTime*42)*96000000 +globalQ.head->t.tv_usec*96;
    //C   LPC_TIM2->MR1 = (globalQ.head->t.tv_sec-gTime*42)*CLK_FREQUENCY +globalQ.head->t.tv_usec*CLK_FRQ;
    //C   LPC_TIM2->MCR |= 8;
    // pc.printf("\n MR1 = %X",LPC_TIM2->MR1);


    //C } else if (globalQ.head->sched == 0) //NO events in this gTime update yet .
    //C  { //turn off the match regiester 1 interrupts.
    //C    LPC_TIM2->MCR &= 3;
    //C }

    //Ctimeval t;
    //C getTime(&t);
    LPC_TIM2->IR = 0xff;
    //  pc.printf("INCREMENTING COUNTER or event %d  \n",t.tv_sec);
}


void getTime(timeval *tv) {
    unsigned int nMSec = (LPC_TIM2->TC)/CLK_FRQ; //gives num of micro sec
    //  unsigned int nMSec = (LPC_TIM0->TC + offset)/72;
    unsigned int nSec = nMSec/1000000;
    tv->tv_sec = gTime*42 + nSec;
    // tv->tv_usec = (LPC_TIM0->TC)*1000 + (float)(LPC_TIM0->PC)/( CLK_FREQUENCY * 1000000);
    tv->tv_usec = nMSec-(nSec*1000000);
}

int curTimeEqualGR(timeval *tv) {
    timeval curT;
    getTime(&curT);
    if (curT.tv_sec == tv->tv_sec) {
        if (curT.tv_usec == tv->tv_usec)
            return 1;
        else
            pc.printf("WROING MICRO CALIBERATION\n");
        return 1;
    } else if (curT.tv_sec > tv->tv_sec) {
        pc.printf("WRONG cur = %d and req = %d \n",curT.tv_sec, tv->tv_sec);
        return 1;
    }
    return 0;
}
int runAtTime(void (*schedFunc)(void), timeval *tv) {
    int ret =0;
    ret = enqueue(&globalQ, *tv, schedFunc);
    //C  if (tv->tv_sec < (gTime+1)*42) {

    //C   if (globalQ.head->sched == 0) {

    //C     LPC_TIM2->MR1 = ((globalQ.head->t.tv_sec%42 )*CLK_FREQUENCY+(globalQ.head->t.tv_usec*CLK_FRQ));
    //C     globalQ.head->sched = 1;
    //C    LPC_TIM2->MCR |= 8;
    //C }
    //C }
    return ret;
}
void trigEX(timeval *tv) {
    pc.printf(" Triggered at %d\n",tv->tv_sec);
}
void trigger(void) {
    timeval curT;
    unsigned int nMSec = (LPC_TIM2->CR0)/CLK_FRQ;
    unsigned int nSec = nMSec/1000000;
    curT.tv_sec = gTime*42 + nSec;
    curT.tv_usec = nMSec-(nSec*1000000);
    gtrigFunc(&curT);
}
void runAtTrigger(void(*trigFunc)(timeval *tv)) {
    gtrigFunc = trigFunc;
    //  trig.rise(&trigger);
    // trig.fall(&trigger);
    //  pc.printf("Runing runAtTrigger\n");
}


void resp_sync_request(void) {
    union {
        unsigned int t;
        char BYTE[4];
    } t2,t3;

    t2.t = LPC_TIM2->TC;

// read the byte ;
    sync.getc();
//    pc.printf(" \n resp_sync_request t2 = %X \n",t2.t);

    wait(0.5);
// read the present time
// serially send out the data over to the slave

    sync.putc(t2.BYTE[0]);
    sync.putc(t2.BYTE[1]);
    sync.putc(t2.BYTE[2]);
    sync.putc(t2.BYTE[3]);

    // Get the present time;

    t3.t = LPC_TIM2->TC;
    sync.putc(t3.BYTE[0]);
    sync.putc(t3.BYTE[1]);
    sync.putc(t3.BYTE[2]);
    sync.putc(t3.BYTE[3]);
    B+=8;
    // pc.printf(" Sync request %X & %X",t2.t, t3.t);
}

void pinToggle(void) {
    toggle = !toggle;
    //C pc.putc('T');
    //C pps.tv_sec++;
    //C runAtTime(&pinToggle,&pps);
}


void reportToggle(timeval *rt) {
    int slv_trg_val = 0;
    //slv_trg_val = LPC_TIM2->CR;

    //pc.putc('T');

    int slv_diff;
    // load the CR0 value

    // slv_diff = (rt->tv_sec - ideal_trg_time[ideal_trg_time_index].tv_sec)*1000000 +
    // rt->tv_usec - ideal_trg_time[ideal_trg_time_index].tv_usec;

    // pc.printf("\n %d %d    %d %d ", rt->tv_sec, rt->tv_usec, ideal_trg_time[ideal_trg_time_index].tv_sec, \
    // ideal_trg_time[ideal_trg_time_index].tv_usec);

    //  ideal_trg_time_index++;
//1 pps part.
//slv_diff = rt->tv_usec -ideal_trg_time[0].tv_usec;
     timeval t;
    getTime(&t);
    if((globalQ.head->t.tv_sec > t.tv_sec) )
        pc.printf(" NOT POPING ele = %d and usec =%d\n", globalQ.head->t.tv_sec, globalQ.head->t.tv_usec);
   
    else 
    {
    qEle *ele = pop(&globalQ);
    if (ele) {
        ele->foo();
        free(ele);
        slv_diff = rt->tv_usec - ele->t.tv_usec;
      //  pc.printf("THE DIFF is %d at sec =q %d --oc  %d and usec = q %d --oc %d\n",slv_diff, ele->t.tv_sec,rt->tv_sec, ele->t.tv_usec,rt->tv_usec);
    timeval t;
    getTime(&t);
    pc.printf(" %d and sec %d and usec = %d and from there %d \n",slv_diff,t.tv_sec, t.tv_usec,rt->tv_usec);
    }
    }

}




#endif