#include "mbed.h"
#include "SDFileSystem.h"
#include "math.h" 
 
 // sd card breakout board: https://www.sparkfun.com/products/544
 //
 // frdm-kl25z sd card connections spi0
 // ------------------------------------------------
 // Header -- kl25z -- SPI          
 // J2-8   -- PTD2  -- MOSI
 // J2-6   -- PTD0  -- CS
 // J9-12  -- GND   -- Vss (GND) 
 // J9-4   -- P3V3  -- Vdd (+3.3v)
 // J2-12  -- PTD1  -- SCK
 // J9-14  -- GND   -- Vss (GND)
 // J2-10  -- PTD3  -- MISO
AnalogIn   ain(A0);
AnalogIn   ain2(A1);
AnalogIn   ain3(A2);  
 char buffer[3];
 int t1;
 float a;
 float b;
 float c;
SDFileSystem sd(PTD2, PTD3, PTD1, PTD0, "sd"); //  mosi, miso, sck, cs
Serial pc(USBTX,USBRX);
 
int main() {
    
    pc.baud(115200);
    pc.printf("start sd card !\r\n");
    mkdir("/sd/POF", 0777);
      
    FILE *fp = fopen("/sd/POF/test.txt", "w");
    if(fp == NULL) {
        error("Could not open file for write\r\n");
    }
    else
    while (1){
    a=ain.read();
    b=ain2.read();
    c=ain3.read();
    wait(0.0050);
    fprintf(fp,"%0.3f, %0.3f,%0.3f\n",a, b,c );
    }
    
    fclose(fp);
    
}