#include "mbed.h"
#include "C12832.h"

C12832 lcd(SPI_MOSI, SPI_SCK, SPI_MISO, p8, p11);

static char Santa1[] = {
  0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //xxxxxx__, xxxxxxxx, xxxxxxxx, xxxxxxxx, xxxxxxxx, xxxxxxxx, xxxxxxxx,
  0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //xxxxxx__, xxxxxxxx, xxxxxxxx, xxxxxxxx, xxxxxxxx, xxxxxxxx, xxxxxxxx,
  0x07, 0x80, 0x00, 0x03, 0x00, 0xc0, 0x00, //xxxxxx_, x_xxxxxx, xxxxxxxx, xxxxxx_, xxxxxxxx, __xxxxxx, xxxxxxxx,
  0x00, 0x90, 0x00, 0x01, 0xff, 0x80, 0x00, //xxxxxxxx, xx_xxxx, xxxxxxxx, xxxxxxx, ____, _xxxxxxx, xxxxxxxx,
  0x00, 0x48, 0x00, 0x00, 0xff, 0x00, 0x00, //xxxxxxxx, x_xx_xxx, xxxxxxxx, xxxxxxxx, ____, xxxxxxxx, xxxxxxxx,
  0x00, 0x24, 0x00, 0x00, 0x7e, 0x00, 0x00, //xxxxxxxx, xx_xx_xx, xxxxxxxx, xxxxxxxx, x____x, xxxxxxxx, xxxxxxxx,
  0x00, 0x26, 0xff, 0xff, 0xff, 0x00, 0x00, //xxxxxxxx, xx_xx_x, ___, ___, ___, xxxxxxxx, xxxxxxxx,
  0x00, 0x3f, 0xff, 0xff, 0xff, 0x00, 0x00, //xxxxxxxx, xx___, ___, ___, ___, xxxxxxxx, xxxxxxxx,
  0x00, 0x3f, 0xff, 0xff, 0xfe, 0x00, 0x00, //xxxxxxxx, xx___, ___, ___, ____x, xxxxxxxx, xxxxxxxx,
  0x00, 0x7f, 0xff, 0xff, 0xfc, 0x00, 0x00, //xxxxxxxx, x___, ___, ___, ____xx, xxxxxxxx, xxxxxxxx,
  0x00, 0x3f, 0x00, 0x03, 0xf8, 0x00, 0x00, //xxxxxxxx, xx___, xxxxxxxx, xxxxxx, ____xxx, xxxxxxxx, xxxxxxxx,
  0x00, 0x7f, 0x00, 0x07, 0xbc, 0x00, 0x00, //xxxxxxxx, x___, xxxxxxxx, xxxxx__, _x___xx, xxxxxxxx, xxxxxxxx,
  0x00, 0xef, 0x00, 0x0f, 0x3c, 0x00, 0x00, //xxxxxxxx, __x_, xxxxxxxx, xxxx__, xx____xx, xxxxxxxx, xxxxxxxx,
  0x00, 0x37, 0x00, 0x00, 0x1f, 0x00, 0x00, //xxxxxxxx, _xxx_, xxxxxxxx, xxxxxxxx, xxx__, xxxxxxxx, xxxxxxxx,
  0x00, 0xc7, 0x80, 0x00, 0x0f, 0x00, 0x00, //xxxxxxxx, xxxxxx_, _xxxxxxx, xxxxxxxx, xxxx_, xxxxxxxx, xxxxxxxx,
  0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, //xxxxxxxx, xxxxxxxx, xxxxxxxx, xxxxxxxx, xxxxxxxx, xxxxxxxx, xxxxxxxx,
};

Bitmap bitmSan1 = {
  40, // XSize
  16, // YSize
  7,  // Bytes in Line
  Santa1 ,  // Pointer to picture data
};


static char Santa2[] = {
    0x03, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x06, 0x80, 0x00, 0x00, 0x00, 0x00,
    0x04, 0x40, 0x00, 0x03, 0x00, 0xC0,
    0x00, 0x90, 0x00, 0x01, 0x80, 0x00,
    0x00, 0x48, 0x00, 0x00, 0xFF, 0x00,
    0x00, 0x24, 0x00, 0x00, 0x8E, 0x00,
    0x00, 0x26, 0xFF, 0xFF, 0xFF, 0x00,
    0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0x00,
    0x00, 0x3F, 0xFF, 0xFF, 0xFE, 0x00,
    0x00, 0x7F, 0xFF, 0xFF, 0xFC, 0x00,
    0x00, 0x3F, 0x00, 0x00, 0xF8, 0x00,
    0x00, 0x3F, 0x00, 0x00, 0x9C, 0x00,
    0x00, 0x0F, 0x80, 0x01, 0x1C, 0x00,
    0x00, 0x07, 0x00, 0x00, 0x0F, 0x00,
    0x00, 0x03, 0x80, 0x00, 0x07, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

Bitmap bitmSan2 = {
  40, // XSize
  16, // YSize
  6,  // Bytes in Line
  Santa2 ,  // Pointer to picture data
};


static char Santa3[] = {
     0x03, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x06, 0x80, 0x00, 0x00, 0x00, 0x00,
    0x04, 0x40, 0x00, 0x03, 0x00, 0xC0,
    0x00, 0x90, 0x00, 0x01, 0x80, 0x00,
    0x00, 0x48, 0x00, 0x00, 0xFF, 0x00,
    0x00, 0x24, 0x00, 0x00, 0x8E, 0x00,
    0x00, 0x26, 0xFF, 0xFF, 0xFF, 0x00,
    0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0x00,
    0x00, 0x3F, 0xFF, 0xFF, 0xFE, 0x00,
    0x00, 0x7F, 0xFF, 0xFF, 0xFC, 0x00,
    0x00, 0x3F, 0x00, 0x00, 0xF8, 0x00,
    0x00, 0x3F, 0x00, 0x00, 0x9C, 0x00,
    0x00, 0x0F, 0x80, 0x01, 0x1C, 0x00,
    0x00, 0x07, 0x00, 0x00, 0x0F, 0x00,
    0x00, 0x03, 0x80, 0x00, 0x07, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

Bitmap bitmSan3 = {
  40, // XSize
  16, // YSize
  6,  // Bytes in Line
  Santa3 ,  // Pointer to picture data
};

AnalogIn pot1(p15);

int main() {
    int i, s, x, a;
    lcd.cls();
    s = 5;
    a = -15;
    lcd.setmode(XOR); // XOR - a second print will erase
    while(1)
    {
        x = 127*pot1.read();
        if(x>=a)
        {
            for (i = a; i < x;)
            {
                lcd.print_bm(bitmSan1, i, 5);
                wait(0.2);
                lcd.copy_to_lcd(); // update lcd
                lcd.print_bm(bitmSan1, i, 5); // erase
                i = i + s;
                lcd.print_bm(bitmSan2, i, 5); // print next
                wait(0.2);
                lcd.copy_to_lcd(); // update lcd
                lcd.print_bm(bitmSan2, i, 5); // erase
                i = i + s;
                lcd.print_bm(bitmSan3, i, 5); // print next
                wait(0.2);
                lcd.copy_to_lcd(); // update lcd
                lcd.print_bm(bitmSan3, i, 5); // erase
                i = i + s;
            }
            a = x;
        }
        else
        {
            for (i = a; i > x;)
            {
                lcd.print_bm(bitmSan1, i, 5);
                wait(0.2);
                lcd.copy_to_lcd(); // update lcd
                lcd.print_bm(bitmSan1, i, 5); // erase
                i = i - s;
                lcd.print_bm(bitmSan2, i, 5); // print next
                wait(0.2);
                lcd.copy_to_lcd(); // update lcd
                lcd.print_bm(bitmSan2, i, 5); // erase
                i = i - s;
                lcd.print_bm(bitmSan3, i, 5); // print next
                wait(0.2);
                lcd.copy_to_lcd(); // update lcd
                lcd.print_bm(bitmSan3, i, 5); // erase
                i = i - s;
            }   
            a = x;
        }
        wait_ms(500); 
    }
}