#include "mbed.h"

#include <string.h>

#define BAUD_RATE 115200

#define SET_MASK  0xFFFF
#define RESET_MASK 0x0000

#define GPIO_SET      SET_MASK
#define GPIO_CLEAR    RESET_MASK

BusOut aIOs(PA_9, PA_10, PA_11, PA_12);
BusOut bIOs(PB_4, PB_5, PB_6, PB_7);
BusOut cIOs(PC_6, PC_7, PC_8, PC_9);
BusOut dIOs(PB_12, PB_13, PB_14, PB_15);

Serial s(USBTX, USBRX); //default for nrf51 is p0.09 p0.11
    
// Sample using PWM for square wave
PwmOut led1(LED1);

// Period must be higher than seconds
void square_wave1(float period, unsigned int duty){
    led1.period(period);
    led1.pulsewidth(duty);  
}

// Sample using ticker
// NOTE : LED2 is used just as example. On F411 not mounted...
//DigitalOut led2(LED2);
Ticker flipper;
unsigned int counter = 0;

void flip() {
    counter = !counter;
    s.printf("Flip : %d", counter);
    wait(0.7f);
    s.printf("OK\r\n");    
}


// Command string
char action[256];
char command[12];
char port;
unsigned short val;


// Test GPIO
class TestPin {
public:
    TestPin(PinName pin) : _interrupt(pin) {        // create the InterruptIn on the pin specified to Counter
        _interrupt.rise(this, &TestPin::increment); // attach increment function of this counter instance
    }
 
    void increment() {
        _count++;
    }
 
    int read() {
        return _count;
    }
 
private:
    InterruptIn _interrupt;
    volatile int _count;
};


// Instantiate Test Pin
TestPin test(PC_10);

// Handle action
int handle_action(char port, int action)
{
    switch (port) {
        case 'a':
        case 'A':
            aIOs = action;
            break;
        case 'b':
        case 'B':
            bIOs = action;
            break;
        case 'c':
        case 'C':
            cIOs = action;
            break;
        case 'd':
        case 'D':
            dIOs = action;
            break;
        default:
            return -1;
            break;
    }

    return 0;
}

int print_action(char port)
{
    switch (port) {
        case 'a':
        case 'A':
            s.printf("Read: PB%c %x\r\n", port, aIOs.read()); 
            break;
        case 'b':
        case 'B':
            s.printf("Read: PB%c %x\r\n", port, bIOs.read()); 
            break;
        case 'c':
        case 'C':
            s.printf("Read: PB%c %x\r\n", port, cIOs.read()); 
            break;
        case 'd':
        case 'D':
            s.printf("Read: GPIO%c %x\r\n", port, dIOs.read());
            break;
        default:
            return -1;
            break;
    }

    return 0;
}




// Main routine
int main()
{
    int ret = 0;
    // Initialize serial console
    //Configure boud rate
    s.baud(BAUD_RATE);

    // Initailize PWM
    square_wave1(4.0f, 2.0f);
    
    // Initialize ticker
    flipper.attach(&flip, 3.0f); 
    
    while(1) {
        memset(action, 0x0, sizeof(action));
        s.printf("Action:\r\n");
        s.scanf( "%s %c" , action, &port);  
        if (strstr(action, "Set") != NULL){
                s.printf("Command: %s %c\r\n", action, port);                
                s.printf("Set GPIOs P%c\r\n", port);
                ret = handle_action(port, GPIO_SET);
        } else if (strstr(action, "Reset") != NULL){
                s.printf("Command: %s %c\r\n", action, port);
                s.printf("Reset GPIOs P%c\r\n", port);
                ret = handle_action(port, GPIO_CLEAR);          
        } else if (strstr(action, "Read") != NULL) {
            ret = print_action(port);
        } else {
           ret = 1;
           s.printf("ERROR: %s unhandled action\r\n",action);
           }
           
        s.printf("IRQ: %d\r\n", test.read());    
        s.printf("Done:%d\r\n", ret);
        ret = 1;

        memset(action, 0x0, sizeof(action));
    }
}
 