#include "mbed.h"

const int addr=0xD0;
unsigned char var1,var2,var3,var4,var5,var6;
int i;

Serial pc(USBTX, USBRX, "pc");

I2C i2c(p28, p27); 

void read_rtc_sec()
{  
    i2c.start();   
    i2c.write(0xD0);
    i2c.write(0x00);
          
    i2c.start();
    i2c.write(0xD1);
    var1=i2c.read(0x00);
  
    var2=var1;
    var1=var1&0x0f;
    var2=var2>>4;
    i2c.stop();
      
    }

void read_rtc_min()
{  
    i2c.start();  
    i2c.write(0xD0);
    i2c.write(0x01);
 
    i2c.start();
    i2c.write(0xD1);
    var3=i2c.read(0x00);    
    
    var4=var3;
    var3=var3&0x0f;
    var4=var4>>4;

    i2c.stop();
    }


void read_rtc_hrs()
{  
    i2c.start();  
    i2c.write(0xD0);
    i2c.write(0x02);
        
    i2c.start();
    i2c.write(0xD1);
    var5=i2c.read(0x00);    

    var6=var5;
    var5=var5&0x0f;
    var6=var6>>4;
    var6=var6&0x01;
 
    i2c.stop();
    }
    
void write_rtc_min(unsigned char mn)
{
    i2c.start();
    i2c.write(addr);
    i2c.write(0x01);
    i2c.write(mn); //write min
    i2c.stop();
   
}

 void write_rtc_sec(unsigned char sc)
 {
    i2c.start();
    i2c.write(addr);
    i2c.write(0x00);
    i2c.write(sc); // write sec 
    i2c.stop();
  }
  

void write_rtc_hrs(unsigned char hr)  
{    
    i2c.start();
    i2c.write(addr);
    i2c.write(0x02);
    i2c.write(hr); //write hrs
    i2c.stop();
         
    }


int main() 
{

char sec=0x45; // second field value
char min=0x59; // min field value
char hrs=0x52; // hrs field value 
    
    
    i2c.frequency(100000);
    i2c.start();
    wait(1);
    
    i2c.start();
    write_rtc_min(min);
    write_rtc_sec(sec);
    write_rtc_hrs(hrs);

 
    
    while(1)
    {
    read_rtc_hrs();
    read_rtc_min();
    read_rtc_sec();
 
    pc.printf("Current time = (%d%d:%d%d:%d%d)\n\r",var6,var5,var4,var3,var2,var1);
    
    wait(1);
     
    }
    
     }