#include "CoordCommands.h"

CoordinatorCommands::CoordinatorCommands(Serial* _serialXB, Serial* _pc, char* panID, int panIDLength) :
m_InFrame(false)
{
    m_Xbee = _serialXB;
    m_PC = _pc;
    SetPanID(panID, panIDLength);
}
void CoordinatorCommands::SetPanID(char* panID, int panIDLength)
{
    //7E 00 09 09 3D 49 44 C0 FF EE BA BE 07
    SendCommand( 0x00, 0x09, 0x09, 0x40, 0x49, 0x44, panID, panIDLength);   
}

void CoordinatorCommands::SendCommand(char lengthMSB, char lengthLSB, char frameType, char frameID, char aTCommandMSB, char aTCommandLSB, char* parameterValue, int paramLength)
{
    char cmd[100]; 
    int cmdLength;
    cmd[0] = START_DELIMITER;
    cmd[1] = lengthMSB;
    cmd[2] = lengthLSB; 
    cmd[3] = frameType;
    cmd[4] = frameID;
    cmd[5] = aTCommandMSB;
    cmd[6] = aTCommandLSB;
    
    cmdLength = 6; 
    for(int i = 0 ; i < paramLength ; i++)
    {   
        cmdLength++;
        cmd[cmdLength] = parameterValue[i];
    }
    
    uint8_t checksum = 0;
    for(int i = 3 ; i <= cmdLength ; i++ )
    {
        checksum += cmd[i];
    }
    
    cmdLength++;
    cmd[cmdLength] = 0xFF - checksum;
    
    if(m_Xbee->writeable())
    {
        for(int i = 0 ; i <= cmdLength ; i++)
        {
            m_Xbee->putc(cmd[i]);
            m_PC->printf("%X", cmd[i]);
        }
    }    
}

void CoordinatorCommands::LectureDeTrame()
{
    if(m_Xbee->readable())
    {
        char currentChar = m_Xbee->getc();
        
        if(m_InFrame)
        {
                
        }
            
    }
    
}