#include "mbed.h"

Serial pc(USBTX, USBRX);

//Affichage
SPI affichage(p5, p6, p7); // mosi, miso, sclk
DigitalOut cs(p8);

//Accéléro
I2C accelero(p28, p27);
const int ADDR_ACCELERO = 0x1D;
const int ADDR_ACC_ACTIVATE = 0x2a;

//Led
DigitalOut myled(LED1);


void readI2C(int addr, char* cmd, int bytesNumber)
{
    int addrShifter = ADDR_ACCELERO << 1;    
    accelero.read(addrShifter, cmd, bytesNumber);  
}

void writeI2C(int addr, char* cmd, int bytesNumber)
{
    int addrShifter = (ADDR_ACCELERO << 1) | 0x01;
    accelero.write(addrShifter, cmd, bytesNumber);       
}

int main() {
    
    //Setup affichage
    cs = 1;
    
    affichage.format(8,0);
    affichage.frequency(250000000);
    
    cs = 0;    
    affichage.write(0x76);
    
    //Setup accelero
    char cmd[2];
    cmd[0] = ADDR_ACC_ACTIVATE;
    readI2C(ADDR_ACCELERO, cmd, 2);
    cmd[1] = cmd[1] | 0x01;
    writeI2C(ADDR_ACCELERO | 0x01, cmd, 2);
    pc.printf("Registre activité: %1f %1f\r\n", cmd[0], cmd[1]);
    
    affichage.write(1);
    affichage.write(3);
    affichage.write(3);
    affichage.write(7);
    
    
    /*
    while(1) 
    {
        affichage.write(1337);
        wait(0.25);
    }*/
}


