#ifndef _ENGLISH_
#define _ENGLISH_


/******************************************************************************
 * Definitions
 ******************************************************************************/
// neutralize AVR PROGMEM stuff
#define PROGMEM
#define pgm_read_byte(addr) (*(const unsigned char *)(addr))
#define pgm_read_word(addr) ({ \
    typeof(addr) _addr = (addr); \
    *(const unsigned short *)(_addr); \
})

typedef uint8_t byte;
typedef bool boolean;


#ifndef TRUE
#define FALSE 0
#define TRUE -1
#endif 

#define numVocab sizeof(s_vocab)/sizeof(VOCAB)
#define numPhoneme sizeof(s_phonemes)/sizeof(PHONEME)

typedef struct Vocab {
    const char* txt;
    const char* phoneme;
} VOCAB;

typedef struct Phoneme {
    const char* txt;
    const char* phoneme;
    uint8_t attenuate;
} PHONEME;

typedef struct strSoundIndex{
    uint8_t SoundNumber;
    int8_t byte1;
    uint8_t byte2;
} SOUND_INDEX;

/*
* Define vocabulary and phonemes for English
*
*/

static const char v1a[] PROGMEM="OUS_";
static const char v1b[] PROGMEM="/U5S";

static const char v2a[] PROGMEM="I#Y";
static const char v2b[] PROGMEM="IY#EE";

static const char v3a[] PROGMEM=" #ERE";
static const char v3b[] PROGMEM=" #EE5ER";

static const char v4a[] PROGMEM="GTH_";
static const char v4b[] PROGMEM="TH";

static const char v5a[] PROGMEM="NGER";
static const char v5b[] PROGMEM="NXGER";

static const char v6a[] PROGMEM="AGE_";
static const char v6b[] PROGMEM="AYJ";

static const char v7a[] PROGMEM="BBC";
static const char v7b[] PROGMEM="BEE5%%BEESEE";

static const char v8a[] PROGMEM="MICRO";
static const char v8b[] PROGMEM="MIY5KROW";

static const char v9a[] PROGMEM="O#U";
static const char v9b[] PROGMEM="OW5#";

static const char v10a[] PROGMEM="AUGH";
static const char v10b[] PROGMEM="AA5F";

static const char v11a[] PROGMEM="KN";
static const char v11b[] PROGMEM="N";

static const char v12a[] PROGMEM="#EY_";
static const char v12b[] PROGMEM="#EEY";

static const char v13a[] PROGMEM=" OUGHT";
static const char v13b[] PROGMEM="AO4T";

static const char v14a[] PROGMEM="XC";
static const char v14b[] PROGMEM="KS";

static const char v15a[] PROGMEM="YS";
static const char v15b[] PROGMEM="IH4S";

static const char v16a[] PROGMEM=" #OUGH_";
static const char v16b[] PROGMEM=" #AHF";

static const char v17a[] PROGMEM="ERY_";
static const char v17b[] PROGMEM="EH4REE";

static const char v18a[] PROGMEM="OUGH_";
static const char v18b[] PROGMEM="OH5W";

static const char v19a[] PROGMEM=" SCI";
static const char v19b[] PROGMEM=" SIY";

static const char v20a[] PROGMEM="CHN";
static const char v20b[] PROGMEM="KN";

static const char v21a[] PROGMEM="OGY";
static const char v21b[] PROGMEM="OJEE";

static const char v22a[] PROGMEM="IRO";
static const char v22b[] PROGMEM="IYRO";

static const char v23a[] PROGMEM="SUPERIOR";
static const char v23b[] PROGMEM="SUX4PEE5RIHAOR";

static const char v24a[] PROGMEM="CI";
static const char v24b[] PROGMEM="SIH";

static const char v25a[] PROGMEM="TCH";
static const char v25b[] PROGMEM="CH";

static const char v26a[] PROGMEM="GHOTI";
static const char v26b[] PROGMEM="FIH4SH";

static const char v27a[] PROGMEM="UE_";
static const char v27b[] PROGMEM="UW6";

static const char v28a[] PROGMEM=" YES_";
static const char v28b[] PROGMEM=" YEH5S";

static const char v29a[] PROGMEM="GUE_";
static const char v29b[] PROGMEM="G";

static const char v30a[] PROGMEM="URE_";
static const char v30b[] PROGMEM="UH5R";

static const char v31a[] PROGMEM="UY";
static const char v31b[] PROGMEM="IY5";

static const char v32a[] PROGMEM="OUGH";
static const char v32b[] PROGMEM="AH";

static const char v33a[] PROGMEM=" #IE";
static const char v33b[] PROGMEM=" #IY";

static const char v34a[] PROGMEM="OLE_";
static const char v34b[] PROGMEM="OW4L";

static const char v35a[] PROGMEM=" ABLE";
static const char v35b[] PROGMEM=" AY5BL";

static const char v36[] PROGMEM="IY";

static const char v37a[] PROGMEM="AIGH";
static const char v37b[] PROGMEM="AY";

static const char v38a[] PROGMEM="ABLE";
static const char v38b[] PROGMEM="AHB/UL";

static const char v39a[] PROGMEM="CHR";
static const char v39b[] PROGMEM="KR";

static const char v40a[] PROGMEM="ITLE";
static const char v40b[] PROGMEM="IYT/UL";

static const char v41a[] PROGMEM="A#I";
static const char v41b[] PROGMEM="AY5#";

static const char v42a[] PROGMEM="SHALL";
static const char v42b[] PROGMEM="SHAEL";

static const char v43a[] PROGMEM="ARE";
static const char v43b[] PROGMEM="AI5R";

static const char v44a[] PROGMEM="A_";
static const char v44b[] PROGMEM="AH";

static const char v45a[] PROGMEM="OE";
static const char v45b[] PROGMEM="OW5";

static const char v46a[] PROGMEM="ANGE_";
static const char v46b[] PROGMEM="AY4NJ";

static const char v47a[] PROGMEM="ANGE";
static const char v47b[] PROGMEM="AY4NJ/U";

static const char v48[] PROGMEM="/U";

static const char v49a[] PROGMEM=" GET";
static const char v49b[] PROGMEM=" GEHT";

static const char v50a[] PROGMEM="IED";
static const char v50b[] PROGMEM="AY5D";

static const char v51a[] PROGMEM="ALLY";
static const char v51b[] PROGMEM="AE4LEE";

static const char v52a[] PROGMEM="A#A";
static const char v52b[] PROGMEM="AY#";

static const char v53a[] PROGMEM="REAT";
static const char v53b[] PROGMEM="RAY5T";

static const char v54a[] PROGMEM="COME_";
static const char v54b[] PROGMEM="KAHM";

static const char v55a[] PROGMEM="OULD_";
static const char v55b[] PROGMEM="UH5D";

static const char v56a[] PROGMEM=" ANY";
static const char v56b[] PROGMEM=" EH4NEE";

static const char v57a[] PROGMEM="O#O";
static const char v57b[] PROGMEM="OW4#";

static const char v58a[] PROGMEM="O#A";
static const char v58b[] PROGMEM="OW4#";

static const char v59a[] PROGMEM="A#E";
static const char v59b[] PROGMEM="AY6#";

static const char v60a[] PROGMEM="I#E";
static const char v60b[] PROGMEM="IY5#";

static const char v61a[] PROGMEM="A#O";
static const char v61b[] PROGMEM="AY#";

static const char v62a[] PROGMEM="O#E";
static const char v62b[] PROGMEM="OW5#";

static const char v63a[] PROGMEM="U#E";
static const char v63b[] PROGMEM="IHUW5#";

static const char v64a[] PROGMEM="U#A";
static const char v64b[] PROGMEM="UXW#";

static const char v65a[] PROGMEM="TU#E";
static const char v65b[] PROGMEM="CHUW#";

static const char v66a[] PROGMEM=" U#E";
static const char v66b[] PROGMEM=" YUXW#";

static const char v67a[] PROGMEM="IE";
static const char v67b[] PROGMEM="EE";

static const char v68a[] PROGMEM="U#I";
static const char v68b[] PROGMEM="YUXW#";

static const char v69a[] PROGMEM="OOK";
static const char v69b[] PROGMEM="UH5K";

static const char v70a[] PROGMEM="COW";
static const char v70b[] PROGMEM="KAW";

static const char v71a[] PROGMEM="NGS_";
static const char v71b[] PROGMEM="NXZ";

static const char v72a[] PROGMEM="STION";
static const char v72b[] PROGMEM="S%CH/UN";

static const char v73a[] PROGMEM="GOO";
static const char v73b[] PROGMEM="GUH4";

static const char v74a[] PROGMEM="HOW";
static const char v74b[] PROGMEM="/HAW4";

static const char v75a[] PROGMEM="NOW";
static const char v75b[] PROGMEM="NAW";

static const char v76a[] PROGMEM="POW";
static const char v76b[] PROGMEM="PAW5";

static const char v77a[] PROGMEM="ERR";
static const char v77b[] PROGMEM="EH4R";

static const char v78a[] PROGMEM="DOW";
static const char v78b[] PROGMEM="DAW4";

static const char v79a[] PROGMEM="SES_";
static const char v79b[] PROGMEM="SIXZ";

static const char v80a[] PROGMEM="PROG";
static const char v80b[] PROGMEM="PROW4G";

static const char v81a[] PROGMEM="NGE";
static const char v81b[] PROGMEM="NJ";

static const char v82a[] PROGMEM="DO_";
static const char v82b[] PROGMEM="DUH4W";

static const char v83a[] PROGMEM="OU";
static const char v83b[] PROGMEM="AE4UX";

static const char v84a[] PROGMEM=" OUR";
static const char v84b[] PROGMEM=" AW5R";

static const char v85a[] PROGMEM="OUR";
static const char v85b[] PROGMEM="AO5R";

static const char v86a[] PROGMEM=" ONE";
static const char v86b[] PROGMEM=" WO4N";

static const char v87a[] PROGMEM="AU";
static const char v87b[] PROGMEM="AO5";

static const char v88a[] PROGMEM="OIC";
static const char v88b[] PROGMEM="OYS";

static const char v89a[] PROGMEM="O_";
static const char v89b[] PROGMEM="OW";

static const char v90a[] PROGMEM="AVI";
static const char v90b[] PROGMEM="AY4VIX";

static const char v91a[] PROGMEM="ES_";
static const char v91b[] PROGMEM="S";

static const char v92a[] PROGMEM="ULL";
static const char v92b[] PROGMEM="UH5L";

static const char v93[] PROGMEM="UH";

static const char v94a[] PROGMEM="FOOT";
static const char v94b[] PROGMEM="FUH4T";

static const char v95a[] PROGMEM="UL_";
static const char v95b[] PROGMEM="/UL";

static const char v96a[] PROGMEM="EFUL_";
static const char v96b[] PROGMEM="F/UL";

static const char v97a[] PROGMEM="EASE_";
static const char v97b[] PROGMEM="EEZ";

static const char v98a[] PROGMEM="DG";
static const char v98b[] PROGMEM="J";

static const char v99a[] PROGMEM="OA";
static const char v99b[] PROGMEM="OH5W";

static const char v100a[] PROGMEM="GEN";
static const char v100b[] PROGMEM="JEH5N";

static const char v101a[] PROGMEM="LE_";
static const char v101b[] PROGMEM="/UL";

static const char v102a[] PROGMEM="YPE";
static const char v102b[] PROGMEM="IY4P";

static const char v103a[] PROGMEM="TLE";
static const char v103b[] PROGMEM="TL";

static const char v104a[] PROGMEM="IGI";
static const char v104b[] PROGMEM="IX4JIH";

static const char v105a[] PROGMEM="WHO";
static const char v105b[] PROGMEM="/HUHW";

static const char v106a[] PROGMEM="NION";
static const char v106b[] PROGMEM="NIX/UN";

static const char v107a[] PROGMEM="WAS_";
static const char v107b[] PROGMEM="WOZ";

static const char v108a[] PROGMEM="ORE_";
static const char v108b[] PROGMEM="AO4R";

static const char v109a[] PROGMEM=" TO_";
static const char v109b[] PROGMEM=" TUX5";

static const char v110a[] PROGMEM="ALK";
static const char v110b[] PROGMEM="AORK";

static const char v111a[] PROGMEM=" BE_";
static const char v111b[] PROGMEM="BEE5";

static const char v112a[] PROGMEM="TIO";
static const char v112b[] PROGMEM="SHAH";

static const char v113a[] PROGMEM="YE_";
static const char v113b[] PROGMEM="IY";

static const char v114a[] PROGMEM="AR";
static const char v114b[] PROGMEM="AA5";

static const char v115a[] PROGMEM="AF";
static const char v115b[] PROGMEM="AA4F";

static const char v116a[] PROGMEM="AST";
static const char v116b[] PROGMEM="AA6ST";

static const char v117a[] PROGMEM="E_";
static const char v117b[] PROGMEM="%";

static const char v118a[] PROGMEM="GHO";
static const char v118b[] PROGMEM="GOH4W";

static const char v119a[] PROGMEM="AZY";
static const char v119b[] PROGMEM="AY5ZEE";

static const char v120a[] PROGMEM="WHA";
static const char v120b[] PROGMEM="WO5";

static const char v121a[] PROGMEM="WAT";
static const char v121b[] PROGMEM="WAO6T";

static const char v122a[] PROGMEM="ALL";
static const char v122b[] PROGMEM="AO4L";

static const char v123a[] PROGMEM=" OF_";
static const char v123b[] PROGMEM=" O5V";

static const char v124a[] PROGMEM="SS";
static const char v124b[] PROGMEM="S";

static const char v125a[] PROGMEM="FF";
static const char v125b[] PROGMEM="F";

static const char v126a[] PROGMEM="CE_";
static const char v126b[] PROGMEM="S";

static const char v127a[] PROGMEM="CE";
static const char v127b[] PROGMEM="SEH4";

static const char v128a[] PROGMEM="TIA";
static const char v128b[] PROGMEM="SHIX/U";

static const char v129a[] PROGMEM=" A_";
static const char v129b[] PROGMEM=" AY";

static const char v130a[] PROGMEM="MB_";
static const char v130b[] PROGMEM="M";

static const char v131a[] PROGMEM="A#Y";
static const char v131b[] PROGMEM="AIIX#EE";

static const char v132a[] PROGMEM="THE_";
static const char v132b[] PROGMEM="DH/U%";

static const char v133a[] PROGMEM=" ARE_";
static const char v133b[] PROGMEM=" AA5R";

static const char v134a[] PROGMEM="Y_";
static const char v134b[] PROGMEM="EE";

static const char v135a[] PROGMEM="SIO";
static const char v135b[] PROGMEM="ZH/U";

static const char v136a[] PROGMEM=" I_";
static const char v136b[] PROGMEM=" IY6";

static const char v137[] PROGMEM="OW";

static const char v138[] PROGMEM="AW";

static const char v139a[] PROGMEM="WH";
static const char v139b[] PROGMEM="W";

static const char v140[] PROGMEM="T";

static const char v141a[] PROGMEM=" WOR";
static const char v141b[] PROGMEM=" WER5";

static const char v142a[] PROGMEM="WR";
static const char v142b[] PROGMEM="R";

static const char v143a[] PROGMEM="ISM";
static const char v143b[] PROGMEM="IX5Z/UM";

static const char v144a[] PROGMEM=" ME_";
static const char v144b[] PROGMEM=" MEE5";

static const char v145[] PROGMEM="G";

static const char v146[] PROGMEM="D";

static const char v147[] PROGMEM="P";

static const char v148[] PROGMEM="B";

static const char v149a[] PROGMEM="WOO";
static const char v149b[] PROGMEM="WUH";

static const char v150a[] PROGMEM=" GI";
static const char v150b[] PROGMEM=" JIY";

static const char v151a[] PROGMEM="YOU_";
static const char v151b[] PROGMEM="YUW";

static const char v152a[] PROGMEM="AI";
static const char v152b[] PROGMEM="AY4";

static const char v153a[] PROGMEM="IGH";
static const char v153b[] PROGMEM="IY4";

static const char v154a[] PROGMEM="IR";
static const char v154b[] PROGMEM="ER6";

static const char v155a[] PROGMEM="UAL";
static const char v155b[] PROGMEM="Y/UL";

static const char v156a[] PROGMEM="EW";
static const char v156b[] PROGMEM="IHUW";

static const char v157a[] PROGMEM="UR";
static const char v157b[] PROGMEM="ER5R";

static const char v158a[] PROGMEM=" MY_";
static const char v158b[] PROGMEM=" MIY";

static const char v159a[] PROGMEM="A";
static const char v159b[] PROGMEM="AE";

static const char v160a[] PROGMEM="I";
static const char v160b[] PROGMEM="IH";

static const char v161[] PROGMEM="K";

static const char v162a[] PROGMEM="C";
static const char v162b[] PROGMEM="K";

static const char v163[] PROGMEM="W";

static const char v164[] PROGMEM="F";

static const char v165a[] PROGMEM="ZZ";
static const char v165b[] PROGMEM="Z";

static const char v166a[] PROGMEM="ORI";
static const char v166b[] PROGMEM="AORIX4";

static const char v167[] PROGMEM="S";

static const char v168[] PROGMEM="Z";

static const char v169[] PROGMEM="V";

static const char v170[] PROGMEM="L";

static const char v171[] PROGMEM="Y";

static const char v172[] PROGMEM="R";

static const char v173[] PROGMEM="M";

static const char v174[] PROGMEM="N";

static const char v175a[] PROGMEM="U";
static const char v175b[] PROGMEM="AH";

static const char v176[] PROGMEM="O";

static const char v177[] PROGMEM="J";

static const char v178a[] PROGMEM="H";
static const char v178b[] PROGMEM="/H";

static const char v179a[] PROGMEM="PH";
static const char v179b[] PROGMEM="F";

static const char v180a[] PROGMEM="EU";
static const char v180b[] PROGMEM="IHUH4";

static const char v181a[] PROGMEM="OO";
static const char v181b[] PROGMEM="UX";

static const char v182a[] PROGMEM="EE";
static const char v182b[] PROGMEM="EE6";

static const char v183a[] PROGMEM="MM";
static const char v183b[] PROGMEM="M";

static const char v184a[] PROGMEM="NN";
static const char v184b[] PROGMEM="N";

static const char v185[] PROGMEM="AIR";

static const char v186a[] PROGMEM="ERE";
static const char v186b[] PROGMEM="AIR";

static const char v187[] PROGMEM="ER";

static const char v188a[] PROGMEM="OR";
static const char v188b[] PROGMEM="AOR";

static const char v189a[] PROGMEM="LL";
static const char v189b[] PROGMEM="L";

static const char v190a[] PROGMEM="CK";
static const char v190b[] PROGMEM="K";

static const char v191a[] PROGMEM="E";
static const char v191b[] PROGMEM="EH";

static const char v192[] PROGMEM="TH";

static const char v193a[] PROGMEM="TT";
static const char v193b[] PROGMEM="T";

static const char v194[] PROGMEM="DH";

static const char v195a[] PROGMEM="NG_";
static const char v195b[] PROGMEM="NX";

static const char v196a[] PROGMEM="NG";
static const char v196b[] PROGMEM="NXG";

static const char v197a[] PROGMEM="QU";
static const char v197b[] PROGMEM="KW";

static const char v198[] PROGMEM="SH";

static const char v199[] PROGMEM="ZH";

static const char v200[] PROGMEM="OH";

static const char v201a[] PROGMEM="X";
static const char v201b[] PROGMEM="KS";

static const char v202[] PROGMEM="CH";

static const char v203a[] PROGMEM="PP";
static const char v203b[] PROGMEM="P";

static const char v204[] PROGMEM="AY";

static const char v205a[] PROGMEM=" IS_";
static const char v205b[] PROGMEM=" IX6Z";

static const char v206a[] PROGMEM=" SC";
static const char v206b[] PROGMEM=" S";

static const char v207a[] PROGMEM="OOR";
static const char v207b[] PROGMEM="AO5R";

static const char v208a[] PROGMEM="RR";
static const char v208b[] PROGMEM="R";

static const char v209a[] PROGMEM="OI";
static const char v209b[] PROGMEM="OY5";

static const char v210[] PROGMEM="OY";

static const char v211a[] PROGMEM=" AS_";
static const char v211b[] PROGMEM=" AEZ";

static const char v212a[] PROGMEM=" WITH_";
static const char v212b[] PROGMEM=" WIX5DH";

static const char v213a[] PROGMEM="HE_";
static const char v213b[] PROGMEM="/HEE6";

static const char v214a[] PROGMEM=" HAVE_";
static const char v214b[] PROGMEM=" /HAE5V";

static const char v215a[] PROGMEM=" BY";
static const char v215b[] PROGMEM=" BIY3";

static const char v216a[] PROGMEM=" THIS";
static const char v216b[] PROGMEM="  DHIXS";

static const char v217a[] PROGMEM=" WE_";
static const char v217b[] PROGMEM=" WEE5";

static const char v218a[] PROGMEM=" THEY_";
static const char v218b[] PROGMEM=" DHAY4";

static const char v219a[] PROGMEM=" HAS_";
static const char v219b[] PROGMEM=" /HAEZ";

static const char v220a[] PROGMEM=" THEIR_";
static const char v220b[] PROGMEM=" DHAI4R";

static const char v221a[] PROGMEM="DD";
static const char v221b[] PROGMEM="D";

static const char v222a[] PROGMEM=" THAN_";
static const char v222b[] PROGMEM=" DHAE6N";

static const char v223a[] PROGMEM="BB";
static const char v223b[] PROGMEM="B";

static const char v224a[] PROGMEM="GG";
static const char v224b[] PROGMEM="G";

static const char v225a[] PROGMEM=" ONLY_";
static const char v225b[] PROGMEM=" OW5NLEE";

static const char v226a[] PROGMEM=" PEO";
static const char v226b[] PROGMEM=" PEE4";

static const char v227a[] PROGMEM=" SHE_";
static const char v227b[] PROGMEM=" SHEE5";

static const char v228a[] PROGMEM="OTHER";
static const char v228b[] PROGMEM="AHDHER";

static const char v229a[] PROGMEM=" SAID_";
static const char v229b[] PROGMEM=" SAI6D";

static const char v230a[] PROGMEM="Q";
static const char v230b[] PROGMEM="K";

static const char v231a[] PROGMEM=" SOME";
static const char v231b[] PROGMEM=" SAH5M";

static const char v232a[] PROGMEM=" THEN_";
static const char v232b[] PROGMEM=" DHEH5N";

static const char v233a[] PROGMEM="AR_";
static const char v233b[] PROGMEM="AA5R";

static const char v234a[] PROGMEM=" MOST_";
static const char v234b[] PROGMEM=" MOW4ST";

static const char v235a[] PROGMEM="ARR";
static const char v235b[] PROGMEM="AE5R";

static const char v236a[] PROGMEM="URR";
static const char v236b[] PROGMEM="AHR";

static const char v237a[] PROGMEM="ORR";
static const char v237b[] PROGMEM="OR";

static const char v238a[] PROGMEM="PLY";
static const char v238b[] PROGMEM="PLIY";

static const char v239a[] PROGMEM="EY";
static const char v239b[] PROGMEM="AY";

static const char v240a[] PROGMEM="EA";
static const char v240b[] PROGMEM="EE5";

static const char v241a[] PROGMEM="SCR";
static const char v241b[] PROGMEM="SKR";

static const char v242a[] PROGMEM="0";
static const char v242b[] PROGMEM="ZIH5R4OW";

static const char v243a[] PROGMEM="1";
static const char v243b[] PROGMEM="WO5N";

static const char v244a[] PROGMEM="2";
static const char v244b[] PROGMEM="TUH4W";

static const char v245a[] PROGMEM="3";
static const char v245b[] PROGMEM="THREE5";

static const char v246a[] PROGMEM="4";
static const char v246b[] PROGMEM="FAO5R";

static const char v247a[] PROGMEM="5";
static const char v247b[] PROGMEM="FIY5V";

static const char v248a[] PROGMEM="6";
static const char v248b[] PROGMEM="SIH6KS";

static const char v249a[] PROGMEM="7";
static const char v249b[] PROGMEM="SEH5V/UN";

static const char v250a[] PROGMEM="8";
static const char v250b[] PROGMEM="AY5T";

static const char v251a[] PROGMEM="9";
static const char v251b[] PROGMEM="NIY5N";

static const char v252a[] PROGMEM=":";
static const char v252b[] PROGMEM=".";

static const char v253a[] PROGMEM=";";
static const char v253b[] PROGMEM="?";

static const char v254a[] PROGMEM="-";
static const char v254b[] PROGMEM="/";

static const char v255[] PROGMEM=" ";

static const char v256[] PROGMEM=",";

static const char v257[] PROGMEM=".";

static const char v258[] PROGMEM="?";

static const char v259a[] PROGMEM="'";
static const char v259b[] PROGMEM="";

static const char v260a[] PROGMEM="!";
static const char v260b[] PROGMEM=",";

static const char v261a[] PROGMEM="/";
static const char v261b[] PROGMEM=",";

// stand alone characters
static const char v262a[] PROGMEM=" B_";
static const char v262b[] PROGMEM=" BEE5";

static const char v263a[] PROGMEM=" C_";
static const char v263b[] PROGMEM=" SEE5";

static const char v264a[] PROGMEM=" H_";
static const char v264b[] PROGMEM=" AYCH";

static const char v265a[] PROGMEM=" I_";
static const char v265b[] PROGMEM=" IY5";

static const char v266a[] PROGMEM=" F_";
static const char v266b[] PROGMEM=" EHF";

static const char v267a[] PROGMEM=" R_";
static const char v267b[] PROGMEM=" AA5R";

static const char v268a[] PROGMEM=" M_";
static const char v268b[] PROGMEM=" EHM";

static const char v269a[] PROGMEM=" N_";
static const char v269b[] PROGMEM=" EHN";

static const char v270a[] PROGMEM=" J_";
static const char v270b[] PROGMEM=" JAY";


static const VOCAB s_vocab[] PROGMEM={
    { v1a,  v1b} ,{ v2a,  v2b}, {  v3a,  v3b},{  v4a,  v4b},{  v5a,  v5b},{  v6a,  v6b},{  v7a,  v7b},{  v8a,  v8b},{  v9a,  v9b},{ v10a, v10b},
    { v11a, v11b},{ v12a, v12b},{ v13a, v13b},{ v14a, v14b},{ v15a, v15b},{ v16a, v16b},{ v17a, v17b},{ v18a, v18b},{ v19a, v19b},{ v20a, v20b},
    { v21a, v21b},{ v22a, v22b},{ v23a, v23b},{ v24a, v24b},{ v25a, v25b},{ v26a, v26b},{ v27a, v27b},{ v28a, v28b},{ v29a, v29b},{ v30a, v30b},
    { v31a, v31b},{ v32a, v32b},{ v33a, v33b},{ v34a, v34b},{ v35a, v35b},{ v36 , v36 },{ v37a, v37b},{ v38a, v38b},{ v39a, v39b},{ v40a, v40b},
    { v41a, v41b},{ v42a, v42b},{ v43a, v43b},{ v44a, v44b},{ v45a, v45b},{ v46a, v46b},{ v47a, v47b},{ v48 , v48 },{ v49a, v49b},{ v50a, v50b},
    { v51a, v51b},{ v52a, v52b},{ v53a, v53b},{ v54a, v54b},{ v55a, v55b},{ v56a, v56b},{ v57a, v57b},{ v58a, v58b},{ v59a, v59b},{ v60a, v60b},
    { v61a, v61b},{ v62a, v62b},{ v63a, v63b},{ v64a, v64b},{ v65a, v65b},{ v66a, v66b},{ v67a, v67b},{ v68a, v68b},{ v69a, v69b},{ v70a, v70b},
    { v71a, v71b},{ v72a, v72b},{ v73a, v73b},{ v74a, v74b},{ v75a, v75b},{ v76a, v76b},{ v77a, v77b},{ v78a, v78b},{ v79a, v79b},{ v80a, v80b},
    { v81a, v81b},{ v82a, v82b},{ v83a, v83b},{ v84a, v84b},{ v85a, v85b},{ v86a, v86b},{ v87a, v87b},{ v88a, v88b},{ v89a, v89b},{ v90a, v90b},
    { v91a, v91b},{ v92a, v92b},{ v93 , v93 },{ v94a, v94b},{ v95a, v95b},{ v96a, v96b},{ v97a, v97b},{ v98a, v98b},{ v99a, v99b},{v100a,v100b},
    {v101a,v101b},{v102a,v102b},{v103a,v103b},{v104a,v104b},{v105a,v105b},{v106a,v106b},{v107a,v107b},{v108a,v108b},{v109a,v109b},{v110a,v110b},
    {v111a,v111b},{v112a,v112b},{v113a,v113b},{v114a,v114b},{v115a,v115b},{v116a,v116b},{v117a,v117b},{v118a,v118b},{v119a,v119b},{v120a,v120b},
    {v121a,v121b},{v122a,v122b},{v123a,v123b},{v124a,v124b},{v125a,v125b},{v126a,v126b},{v127a,v127b},{v128a,v128b},{v129a,v129b},{v130a,v130b},
    {v131a,v131b},{v132a,v132b},{v133a,v133b},{v134a,v134b},{v135a,v135b},{v136a,v136b},{v137 ,v137 },{v138 ,v138 },{v139a,v139b},{v140 ,v140 },
    {v141a,v141b},{v142a,v142b},{v143a,v143b},{v144a,v144b},{v145 ,v145 },{v146 ,v146 },{v147 ,v147 },{v148 ,v148 },{v149a,v149b},{v150a,v150b},
    {v151a,v151b},{v152a,v152b},{v153a,v153b},{v154a,v154b},{v155a,v155b},{v156a,v156b},{v157a,v157b},{v158a,v158b},{v159a,v159b},{v160a,v160b},
    {v161 ,v161 },{v162a,v162b},{v163 ,v163 },{v164 ,v164 },{v165a,v165b},{v166a,v166b},{v167 ,v167 },{v168 ,v168 },{v169 ,v169 },{v170 ,v170 },
    {v171 ,v171 },{v172 ,v172 },{v173 ,v173 },{v174 ,v174 },{v175a,v175b},{v176 ,v176 },{v177 ,v177 },{v178a,v178b},{v179a,v179b},{v180a,v180b},
    {v181a,v181b},{v182a,v182b},{v183a,v183b},{v184a,v184b},{v185 ,v185 },{v186a,v186b},{v187 ,v187 },{v188a,v188b},{v189a,v189b},{v190a,v190b},
    {v191a,v191b},{v192 ,v192 },{v193a,v193b},{v194 ,v194 },{v195a,v195b},{v196a,v196b},{v197a,v197b},{v198 ,v198 },{v199 ,v199 },{v200 ,v200 },
    {v201a,v201b},{v202 ,v202 },{v203a,v203b},{v204 ,v204 },{v205a,v205b},{v206a,v206b},{v207a,v207b},{v208a,v208b},{v209a,v209b},{v210 ,v210 },
    {v211a,v211b},{v212a,v212b},{v213a,v213b},{v214a,v214b},{v215a,v215b},{v216a,v216b},{v217a,v217b},{v218a,v218b},{v219a,v219b},{v220a,v220b},
    {v221a,v221b},{v222a,v222b},{v223a,v223b},{v224a,v224b},{v225a,v225b},{v226a,v226b},{v227a,v227b},{v228a,v228b},{v229a,v229b},{v230a,v230b},
    {v231a,v231b},{v232a,v232b},{v233a,v233b},{v234a,v234b},{v235a,v235b},{v236a,v236b},{v237a,v237b},{v238a,v238b},{v239a,v239b},{v240a,v240b},
    {v241a,v241b},{v242a,v242b},{v243a,v243b},{v244a,v244b},{v245a,v245b},{v246a,v246b},{v247a,v247b},{v248a,v248b},{v249a,v249b},{v250a,v250b},
    {v251a,v251b},{v252a,v252b},{v253a,v253b},{v254a,v254b},{v255 ,v255 },{v256 ,v256 },{v257 ,v257 },{v258 ,v258 },{v259a,v259b},{v260a,v260b},
    {v261a,v261b},
    {v262a,v262b},{v263a,v263b},{v264a,v264b},{v265a,v265b},{v266a,v266b},{v267a,v267b},{v268a,v268b},{v269a,v269b},{v270a,v270b}

};

static const char p1a[] PROGMEM="dux";
static const char p1b[] PROGMEM="a5V2E8";

static const char p2a[] PROGMEM="ae";
static const char p2b[] PROGMEM="A7";

static const char p3a[] PROGMEM="aa";
static const char p3b[] PROGMEM="B9";

static const char p4a[] PROGMEM="aw";
static const char p4b[] PROGMEM="A9R6";

static const char p5a[] PROGMEM="r";
static const char p5b[] PROGMEM="D7";

static const char p6a[] PROGMEM="ux";
static const char p6b[] PROGMEM="E8";

static const char p7a[] PROGMEM="uw";
static const char p7b[] PROGMEM="E7R6";

static const char p8a[] PROGMEM="ao";
static const char p8b[] PROGMEM="F9";

static const char p9a[] PROGMEM="ee";
static const char p9b[] PROGMEM="G7";

static const char p10a[] PROGMEM="l";
static const char p10b[] PROGMEM="H7";

static const char p11a[] PROGMEM="m";
static const char p11b[] PROGMEM="J7";

static const char p12a[] PROGMEM="ah";
static const char p12b[] PROGMEM="K7";

static const char p13a[] PROGMEM="v";
static const char p13b[] PROGMEM="L5";

static const char p14a[] PROGMEM="/h";
static const char p14b[] PROGMEM="N4";

static const char p15a[] PROGMEM="t";
static const char p15b[] PROGMEM="O1";

static const char p16a[] PROGMEM="p";
static const char p16b[] PROGMEM="P1";

static const char p17a[] PROGMEM="n";
static const char p17b[] PROGMEM="I7";

static const char p18a[] PROGMEM="b";
static const char p18b[] PROGMEM="M1";

static const char p19a[] PROGMEM="k";
static const char p19b[] PROGMEM="Q1";

static const char p20a[] PROGMEM="w";
static const char p20b[] PROGMEM="R7";

static const char p21a[] PROGMEM="ay";
static const char p21b[] PROGMEM="S9U5T2";

static const char p22a[] PROGMEM="y";
static const char p22b[] PROGMEM="T7";

static const char p23a[] PROGMEM="ih";
static const char p23b[] PROGMEM="U7";

static const char p24a[] PROGMEM="ix";
static const char p24b[] PROGMEM="U5";

static const char p25a[] PROGMEM="j";
static const char p25b[] PROGMEM="a3V3a2";

static const char p26a[] PROGMEM="d";
static const char p26b[] PROGMEM="W1";

static const char p27a[] PROGMEM="nx";
static const char p27b[] PROGMEM="X7";

static const char p28a[] PROGMEM="oh";
static const char p28b[] PROGMEM="Y8";

static const char p29a[] PROGMEM="o";
static const char p29b[] PROGMEM="Z8";

static const char p30a[] PROGMEM="er";
static const char p30b[] PROGMEM="[9";

static const char p31a[] PROGMEM="sh";
static const char p31b[] PROGMEM="\\6";

static const char p32a[] PROGMEM="ow";
static const char p32b[] PROGMEM="Y9R5";

static const char p33a[] PROGMEM="oy";
static const char p33b[] PROGMEM="F9U4T2";

static const char p34a[] PROGMEM="ch";
static const char p34b[] PROGMEM="a6\\3a1";

static const char p35a[] PROGMEM="g";
static const char p35b[] PROGMEM="]1";

static const char p36a[] PROGMEM="s";
static const char p36b[] PROGMEM="^5";

static const char p37a[] PROGMEM="f";
static const char p37b[] PROGMEM="_5";

static const char p38a[] PROGMEM="z";
static const char p38b[] PROGMEM="`5";

static const char p39a[] PROGMEM="/";
static const char p39b[] PROGMEM="a9";

static const char p40a[] PROGMEM="th";
static const char p40b[] PROGMEM="b5";

static const char p41a[] PROGMEM="dh";
static const char p41b[] PROGMEM="c4";

static const char p42a[] PROGMEM="/u";
static const char p42b[] PROGMEM="d8";

static const char p43a[] PROGMEM="zh";
static const char p43b[] PROGMEM="e5";

static const char p44a[] PROGMEM="dr";
static const char p44b[] PROGMEM="a2V3D7";

static const char p45a[] PROGMEM="tr";
static const char p45b[] PROGMEM="a4V3D7";

static const char p46a[] PROGMEM="ct";
static const char p46b[] PROGMEM="a2Q1a1O1";

static const char p47a[] PROGMEM="eh";
static const char p47b[] PROGMEM="f7";

static const char p48a[] PROGMEM="uh";
static const char p48b[] PROGMEM="g7";

static const char p49a[] PROGMEM="iy";
static const char p49b[] PROGMEM="B9U6";

static const char p50a[] PROGMEM="ai";
static const char p50b[] PROGMEM="C9";

static const char p51a[] PROGMEM="%";
static const char p51b[] PROGMEM="a1";

static const char p52a[] PROGMEM="j_";
static const char p52b[] PROGMEM="a4V3";

static const char p53a[] PROGMEM=" ";
static const char p53b[] PROGMEM="zz";

static const char p54a[] PROGMEM=",";
static const char p54b[] PROGMEM="a9a2";

static const char p55a[] PROGMEM=".";
static const char p55b[] PROGMEM="i9a5";

static const char p56a[] PROGMEM="?";
static const char p56b[] PROGMEM="h9a5";


static const PHONEME s_phonemes[] PROGMEM= {
    { p1a, p1b,1},{ p2a, p2b,1},{ p3a, p3b,1},{ p4a, p4b,1},{ p5a, p5b,0},{ p6a, p6b,1},{ p7a, p7b,1},{ p8a, p8b,1},
    { p9a, p9b,1},{p10a,p10b,0},{p11a,p11b,0},{p12a,p12b,1},{p13a,p13b,0},{p14a,p14b,1},{p15a,p15b,0},{p16a,p16b,0},
    {p17a,p17b,0},{p18a,p18b,0},{p19a,p19b,0},{p20a,p20b,0},{p21a,p21b,1},{p22a,p22b,0},{p23a,p23b,1},{p24a,p24b,1},
    {p25a,p25b,0},{p26a,p26b,0},{p27a,p27b,0},{p28a,p28b,1},{p29a,p29b,1},{p30a,p30b,1},{p31a,p31b,0},{p32a,p32b,1},
    {p33a,p33b,1},{p34a,p34b,1},{p35a,p35b,0},{p36a,p36b,0},{p37a,p37b,1},{p38a,p38b,0},{p39a,p39b,1},{p40a,p40b,1},
    {p41a,p41b,0},{p42a,p42b,1},{p43a,p43b,0},{p44a,p44b,0},{p45a,p45b,0},{p46a,p46b,0},{p47a,p47b,1},{p48a,p48b,1},
    {p49a,p49b,1},{p50a,p50b,1},{p51a,p51b,0},{p52a,p52b,0},{p53a,p53b,1},{p54a,p54b,0},{p55a,p55b,0},{p56a,p56b,0}
};

static const uint8_t SoundData[] PROGMEM= {
    // A - phoneme 'ae'
 0x74,0xFF,0xFF,0x04,0x30,0xFB,0xCF,0x88,0x88,0x78,0x45,0x95,0xCD,0x6A,0x44,0x85,
 0xAA,0x68,0x65,0x76,0x88,0x88,0x88,0x68,0x55,0x86,0xA9,0x8A,0x56,0x65,0x87,0xA8,
 0xCB,0x8A,0x56,0x85,0xBA,0x8A,0x78,0x87,0x88,0x88,0x88,0x66,0x55,0x76,0x88,0x56,
 0x54,0x65,0x66,0x56,0x55,0x44,0x54,0x66,0x56,0x55,0x65,0x56,0x54,0x86,0x46,0x44,

 // B - phoneme 'aa'
 0x96,0xEE,0xFF,0xED,0x44,0x10,0x52,0xD9,0xEF,0xBD,0x58,0x45,0x66,0x86,0x88,0x77,
 0xA8,0xBA,0x9B,0x48,0x44,0x53,0xA7,0xCB,0xAB,0x68,0x55,0x65,0x87,0x99,0x89,0x88,
 0x88,0xA9,0x99,0x88,0x78,0x98,0xA9,0x99,0x78,0x66,0x87,0x98,0x88,0x68,0x66,0x76,
 0x88,0x88,0x78,0x67,0x66,0x66,0x66,0x66,0x66,0x76,0x77,0x66,0x67,0x67,0x87,0x77,

 //C - phoneme 'ai' 
 0x66,0x96,0xB8,0xFF,0xCB,0xFB,0x9A,0x85,0x73,0x78,0x58,0xBA,0x9D,0x99,0x89,0x88,
 0x44,0x64,0x58,0x86,0xA9,0xAA,0x88,0x86,0x58,0x54,0x76,0x87,0x88,0x99,0x9A,0x78,
 0x88,0x67,0x66,0x86,0x88,0x9A,0xCA,0xAA,0xA8,0x88,0x86,0x76,0x88,0x89,0x88,0x89,
 0x67,0x66,0x65,0x65,0x65,0x66,0x66,0x66,0x56,0x55,0x55,0x55,0x44,0x77,0x68,0x2B,

 //D - phoneme 'r'
 0x44,0x75,0xEA,0xFF,0xAC,0xDA,0xEE,0x5A,0x32,0x65,0x56,0x55,0x76,0xBA,0xCD,0x8B,
 0x87,0x99,0x48,0x22,0x53,0x77,0x66,0x97,0xAA,0xAB,0x8A,0x66,0x76,0x57,0x44,0x75,
 0x98,0x88,0x98,0xAA,0xBB,0xAB,0x89,0x87,0x88,0x56,0x75,0x88,0x88,0x88,0x88,0x68,
 0x56,0x55,0x55,0x55,0x55,0x55,0x66,0x56,0x66,0x56,0x55,0x55,0x44,0x65,0x66,0x55,

 //E - phoneme 'ux'
 0x44,0x54,0x55,0x55,0x76,0xB9,0xFD,0xFF,0xFF,0xEE,0xDE,0xCD,0xAB,0x68,0x45,0x23,
 0x32,0x44,0x44,0x55,0x76,0xA9,0xBA,0xBB,0xAB,0xAA,0x9A,0x89,0x68,0x55,0x44,0x44,
 0x54,0x65,0x66,0x87,0x98,0xA9,0xAA,0xAA,0x9A,0xA9,0xAA,0xAA,0x9A,0x89,0x88,0x88,
 0x88,0x88,0x66,0x55,0x55,0x55,0x55,0x45,0x44,0x54,0x55,0x55,0x45,0x44,0x44,0x54,

 //F - phoneme 'ao'
 0x55,0x65,0x66,0x67,0x87,0xB9,0xEC,0xFF,0xFF,0xCF,0x8A,0x24,0x01,0x31,0x75,0xDA,
 0xFE,0xFF,0xCE,0x8A,0x56,0x44,0x54,0x65,0x88,0x99,0xAA,0xAA,0xBB,0xBB,0xAA,0x89,
 0x57,0x45,0x54,0x75,0xA8,0xCB,0xDD,0xDD,0xBC,0x9A,0x68,0x56,0x55,0x65,0x87,0xA9,
 0xBB,0xBB,0x9A,0x88,0x66,0x55,0x55,0x66,0x87,0x98,0x99,0x99,0x88,0x67,0x56,0x55,

 //G - phoneme 'ee'
 0x35,0x43,0x07,0xE1,0xA4,0x79,0xBD,0xE8,0xFD,0xDA,0xCF,0xDB,0xFB,0x9A,0xAB,0x68,
 0x96,0x45,0x54,0x25,0x52,0x44,0x54,0x56,0x65,0x87,0x76,0x9A,0x98,0xAA,0x99,0xAA,
 0x89,0xA9,0x89,0x88,0x68,0x86,0x68,0x65,0x67,0x85,0x77,0x79,0xA9,0x87,0xAA,0xAA,
 0x9A,0xA9,0x98,0x88,0x88,0x67,0x66,0x55,0x55,0x55,0x54,0x55,0x44,0x45,0x54,0x34,
 
 //H - phoneme 'l'
 0x55,0x55,0x75,0xA8,0xDB,0xFE,0xEF,0xBE,0x8B,0x68,0x55,0x54,0x54,0x55,0x55,0x66,
 0x87,0x99,0xAA,0xAB,0xAA,0x89,0x66,0x55,0x55,0x55,0x65,0x76,0x87,0x88,0x99,0x99,
 0x99,0x9A,0x99,0x99,0x98,0x88,0x88,0x68,0x67,0x67,0x77,0x76,0x66,0x66,0x66,0x66,
 0x66,0x66,0x66,0x66,0x66,0x66,0x66,0x66,0x66,0x66,0x66,0x66,0x66,0x66,0x66,0x55,

 //I - phoneme 'n'
 0x55,0x66,0x66,0x76,0x9A,0xA6,0xBB,0xCB,0xBB,0xDE,0xED,0xDD,0xDD,0xBC,0xBC,0xBA,
 0x9A,0x99,0x78,0x68,0x66,0x56,0x55,0x55,0x55,0x55,0x55,0x66,0x65,0x66,0x76,0x77,
 0x88,0x88,0x88,0x98,0x99,0xAA,0xAA,0xAA,0xBA,0xBA,0xAB,0xAA,0xAA,0x99,0x89,0x88,
 0x68,0x66,0x55,0x55,0x44,0x44,0x44,0x44,0x44,0x44,0x44,0x44,0x54,0x45,0x55,0x65,

 //J - phoneme 'm'
 0x32,0x43,0x34,0x43,0x44,0x55,0x55,0x65,0x76,0xB9,0xA8,0x9A,0xBB,0xCD,0xDD,0xDD,
 0xEE,0xED,0xDD,0xDC,0xBB,0xAB,0x99,0x89,0x88,0x66,0x56,0x55,0x45,0x44,0x54,0x55,
 0x55,0x55,0x65,0x66,0x87,0x88,0x88,0x99,0x99,0xAA,0xAA,0xBA,0xAB,0xBB,0xAB,0xBB,
 0xBB,0xAA,0x9A,0x89,0x88,0x78,0x66,0x56,0x55,0x44,0x44,0x34,0x33,0x33,0x34,0x43,

 //K - phoneme 'ah'
 0x55,0xD7,0xFF,0xBF,0x49,0x33,0x67,0x68,0x89,0xA9,0xDD,0x8B,0x24,0x22,0x95,0xAA,
 0x9A,0x89,0x99,0x58,0x34,0x54,0xA7,0xBB,0x8A,0x68,0x66,0x66,0x65,0x97,0xBA,0xAB,
 0x68,0x55,0x76,0x98,0x89,0x98,0x88,0x68,0x56,0x75,0x88,0x89,0x68,0x66,0x66,0x66,
 0x66,0x76,0x88,0x67,0x56,0x55,0x76,0x67,0x76,0x66,0x77,0x66,0x66,0x56,0x66,0x67,

 //L - phoneme 'v'
 0x99,0x99,0x99,0x78,0x77,0x77,0x67,0x66,0x77,0x77,0x77,0x98,0x99,0x99,0xA9,0xAA,
 0x99,0x99,0x99,0x78,0x77,0x77,0x67,0x66,0x77,0x77,0x77,0x98,0x99,0x99,0xA9,0xAA,
 0x89,0x99,0x99,0x99,0xAA,0x9A,0x99,0x99,0x89,0x77,0x77,0x77,0x66,0x76,0x77,0x77,
 0x87,0x99,0x99,0x99,0xAA,0x9A,0x99,0x99,0x89,0x77,0x77,0x77,0x66,0x76,0x77,0x77,

 //M - phoneme 'b'
 0x86,0x88,0x98,0x88,0x88,0x88,0x99,0x89,0x88,0x88,0x88,0x99,0x88,0x88,0x98,0x99,
 0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x78,0x88,0x87,0x77,0x77,
 0x88,0x88,0x77,0x87,0x88,0x88,0x77,0x66,0x66,0x66,0x56,0x55,0x55,0x55,0x66,0xB8,
 0xFE,0xFF,0xCE,0x9A,0x89,0x48,0x24,0x01,0x20,0x55,0x66,0x56,0x55,0x55,0x24,0x00,
 
 //N - phoneme '/h'
 0x88,0x88,0x68,0x86,0x78,0x97,0x89,0x88,0x76,0x76,0x88,0x89,0x99,0x88,0x68,0x56,
 0x87,0x99,0xA9,0x89,0x66,0x56,0x76,0x88,0x88,0x89,0x78,0x77,0x88,0x88,0x99,0x88,
 0x68,0x55,0x75,0xA9,0x9A,0x89,0x68,0x55,0x66,0x86,0xA9,0x9A,0x88,0x56,0x86,0x88,
 0x88,0x68,0x75,0x77,0x98,0xAA,0x98,0x89,0x58,0x55,0x66,0xB9,0xAB,0x8A,0x58,0x65,
 
 //O - phoneme 't'
 0x96,0x78,0x78,0xB9,0xB8,0x78,0x89,0x76,0x65,0x78,0x4B,0x87,0x75,0x8B,0xB5,0x76,
 0xA8,0xA9,0x44,0x5D,0x49,0x8B,0x83,0x95,0x78,0x1A,0x6C,0x7A,0xC2,0xB4,0x55,0x7B,
 0x85,0xA8,0x78,0x98,0x85,0x87,0xC4,0x85,0x85,0x3B,0xB8,0x47,0x78,0xA4,0x94,0x68,
 0x87,0x66,0x7A,0x7A,0x89,0x67,0xC8,0xA6,0x83,0x7B,0xC5,0xC1,0xB4,0x98,0x87,0xB3,
 
 //P - phoneme 'p'
 0x88,0x99,0x99,0xA9,0xDA,0xBC,0xED,0xCD,0xBB,0xCC,0xDC,0xFD,0xFF,0xFF,0xFF,0xFF,
 0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x8C,0x04,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x32,0x45,0x13,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x11,0x10,0x11,0x11,0x32,0x54,0x55,0x76,0x76,
 
 //Q - phoneme 'k'
 0x99,0x58,0x65,0x88,0x48,0xA3,0xAB,0x76,0xC9,0x4A,0x21,0x84,0x69,0x44,0xC7,0x4A,
 0x52,0xA9,0x48,0x72,0xED,0x8B,0x78,0x55,0x24,0x32,0xF4,0xCF,0x10,0xFB,0x4F,0x54,
 0x98,0x68,0x74,0x88,0x56,0x85,0x89,0x56,0x87,0x78,0x76,0x98,0x99,0x99,0x89,0x68,
 0x76,0x67,0x65,0x98,0x78,0x44,0x54,0xB8,0xAB,0x69,0x55,0x76,0x88,0x56,0x65,0x98,
 
 //R - phoneme 'w'
 0x44,0x55,0x76,0xB9,0xDC,0xFE,0xFF,0xDE,0xCD,0xAB,0x9A,0x88,0x56,0x45,0x23,0x22,
 0x43,0x54,0x86,0x98,0xA9,0xAA,0x9A,0x99,0x99,0x89,0x88,0x56,0x45,0x44,0x54,0x55,
 0x66,0x76,0x87,0x88,0x98,0x99,0x99,0xA9,0x99,0xAA,0xAA,0xAA,0x9A,0x89,0x78,0x66,
 0x66,0x66,0x66,0x56,0x55,0x55,0x55,0x66,0x66,0x66,0x56,0x55,0x55,0x55,0x55,0x55,

 //S - phonene
 0x45,0xB6,0xFF,0xA5,0xFB,0x6A,0x84,0x95,0x56,0x73,0xD9,0x69,0xB8,0x8C,0x56,0x66,
 0x67,0x44,0xA6,0x8A,0x96,0xAA,0x68,0x65,0x76,0x46,0x75,0x99,0x88,0xA9,0x8A,0x67,
 0x76,0x67,0x65,0x97,0x88,0xC9,0x9A,0xA9,0xA9,0x59,0x65,0x89,0x55,0x98,0x88,0x67,
 0x66,0x46,0x54,0x66,0x55,0x86,0x56,0x76,0x56,0x55,0x56,0x65,0x45,0x87,0x58,0x75,

 //T - phoneme 'y'
 0x55,0x95,0x54,0x5C,0x87,0xA9,0xA8,0xAD,0xBB,0xBD,0x9D,0x9F,0xAB,0xAB,0x8A,0x8B,
 0x88,0x88,0x46,0x47,0x44,0x55,0x44,0x55,0x54,0x65,0x55,0x87,0x86,0x97,0x88,0x99,
 0x98,0xA9,0x99,0x9A,0x98,0x99,0x98,0x9A,0x99,0x99,0x98,0x8A,0x88,0x88,0x78,0x68,
 0x66,0x56,0x55,0x45,0x54,0x44,0x54,0x44,0x55,0x54,0x55,0x44,0x45,0x64,0x54,0x47,
 
 //U - phoneme 'ih'
 0xA4,0x58,0xD5,0x1F,0xD7,0x8F,0xD5,0x8F,0xA5,0x88,0x84,0x34,0x95,0x34,0xB6,0x5A,
 0xB7,0x6C,0x89,0x89,0x87,0x55,0x67,0x44,0x87,0x58,0x99,0x89,0x99,0x99,0x88,0x86,
 0x88,0x65,0x88,0x98,0x89,0xAB,0x9B,0xB9,0x89,0x86,0x58,0x65,0x55,0x54,0x55,0x67,
 0x66,0x88,0x66,0x87,0x55,0x56,0x64,0x46,0x75,0x46,0x84,0x59,0x75,0x89,0x74,0x67,
 
 //V - phoneme 'j'
 0x76,0x66,0x67,0x66,0x77,0x87,0x77,0x89,0x88,0x89,0x89,0x89,0xA8,0x99,0x9A,0xA9,
 0x9A,0xBA,0x9A,0x9A,0xA9,0x89,0x89,0x88,0x79,0x87,0x77,0x67,0x66,0x67,0x76,0x76,
 0x67,0x77,0x77,0x88,0x97,0x89,0x99,0x99,0xAA,0xA9,0x9A,0xAA,0xA9,0x9A,0x99,0x89,
 0x99,0x87,0x78,0x77,0x67,0x77,0x76,0x66,0x67,0x66,0x77,0x87,0x77,0x89,0x88,0x89,

 //W - phoneme 'd'
 0x3A,0xFB,0x98,0x6C,0xA9,0xA5,0x5A,0x89,0xA8,0x58,0x67,0x67,0x55,0x55,0x66,0x56,
 0x76,0x88,0x76,0x86,0x87,0x54,0x55,0x47,0x55,0x85,0x65,0x66,0x88,0x8A,0xA8,0xAA,
 0x89,0x98,0x89,0x67,0x88,0x89,0x98,0xBA,0xAB,0xBA,0xBC,0xAB,0xAA,0xAA,0x78,0x87,
 0x78,0x66,0x86,0x88,0x87,0x98,0x88,0x77,0x78,0x56,0x55,0x56,0x44,0x54,0x45,0x44,
 
 //X - phoneme 'nx'
 0x44,0xA6,0xAA,0xBB,0xCB,0xBD,0xBD,0xAB,0xAA,0xBA,0x9A,0x89,0x88,0x88,0x88,0x66,
 0x66,0x66,0x66,0x67,0x87,0x78,0x88,0x88,0x88,0x87,0x77,0x77,0x77,0x77,0x88,0x88,
 0x88,0x99,0xAA,0xAA,0xAA,0xAA,0x99,0x99,0x99,0x88,0x88,0x66,0x66,0x55,0x55,0x55,
 0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x65,0x56,0x55,0x55,0x55,0x55,0x45,

 //Y - phoneme 'oh'
 0x66,0x66,0xF7,0xFF,0x9E,0x5B,0x74,0x88,0x56,0x54,0x75,0xDB,0xBD,0x88,0x46,0x75,
 0x58,0x45,0x65,0xB7,0xCB,0x8A,0x68,0x56,0x76,0x56,0x54,0x87,0xBA,0xAB,0x78,0x77,
 0x66,0x66,0x56,0x96,0xDA,0xBD,0x8B,0x56,0x75,0x67,0x76,0x76,0x98,0x9A,0x88,0x66,
 0x65,0x77,0x66,0x56,0x66,0x87,0x66,0x55,0x65,0x66,0x56,0x65,0x66,0x77,0x88,0x67,

 //Z - phoneme 'o'
 0x95,0xDB,0xFF,0xFF,0x4A,0x02,0x00,0x73,0xFB,0xFF,0xAF,0x48,0x23,0x42,0x75,0x88,
 0x99,0x98,0xAA,0xAA,0x68,0x25,0x22,0x53,0xB8,0xED,0xBD,0x69,0x24,0x32,0x75,0xA9,
 0xAB,0x9A,0x88,0x88,0xA9,0x89,0x67,0x66,0x87,0x89,0x89,0x69,0x67,0x66,0x66,0x66,
 0x55,0x66,0x86,0x78,0x66,0x55,0x55,0x55,0x66,0x66,0x66,0x66,0x66,0x66,0x56,0x45,

 //[ - phoneme 'er'
 0x67,0xD7,0xFF,0xAB,0xCB,0xAC,0x89,0x26,0x52,0x87,0x56,0x86,0xBA,0xCB,0x8B,0x76,
 0x88,0x48,0x44,0x55,0x76,0x89,0x88,0xB9,0xAB,0x88,0x67,0x66,0x66,0x45,0x75,0x98,
 0x99,0x99,0x99,0xBA,0x8A,0x87,0x88,0x78,0x77,0x76,0x98,0x89,0x87,0x88,0x78,0x66,
 0x55,0x65,0x66,0x65,0x66,0x66,0x66,0x56,0x65,0x56,0x55,0x65,0x56,0x66,0x66,0x66,

 // phoneme - 'sh'
 0x8B,0x43,0x97,0x3B,0x93,0x4C,0x55,0x3F,0x74,0x59,0x58,0xC8,0x03,0xC7,0x26,0xC3,
 0x18,0x77,0x7A,0x34,0xC9,0x82,0xA1,0x2B,0x81,0x2D,0x76,0xA8,0x38,0x78,0x7A,0xE0,
 0x48,0xA6,0x83,0x47,0x3B,0xA5,0x3A,0x85,0x3B,0x98,0x64,0x89,0x56,0xB8,0x88,0x83,
 0x67,0x87,0x27,0x77,0x0D,0x73,0x5E,0x72,0xCC,0x70,0xD8,0x44,0x47,0x59,0x98,0x58,
 
 //] - phoneme 'g'
 0x76,0x87,0x88,0x98,0x99,0xAA,0xAA,0xAA,0xAA,0x99,0x89,0x88,0x88,0x77,0x66,0x66,
 0x55,0x45,0x41,0xB7,0xDC,0xBE,0x99,0xB9,0xBB,0x8A,0x45,0x43,0x54,0x55,0x24,0x42,
 0x65,0x76,0x56,0x54,0x65,0x77,0x66,0x86,0xCB,0xED,0xCE,0xBB,0xBA,0xAB,0x99,0x68,
 0x65,0x66,0x76,0x86,0x77,0x87,0x88,0x89,0x88,0x78,0x99,0x99,0x99,0x98,0x99,0x9A,

 // ^ - phoneme 's'
 0xB6,0x75,0x5A,0x4B,0x99,0xB5,0x58,0x5B,0x89,0xA6,0x96,0x68,0x88,0xA6,0x78,0x4A,
 0x8B,0xA5,0xA5,0x4A,0x4B,0xB7,0xB4,0x7A,0x4C,0x87,0xC3,0x78,0x2C,0x4B,0xC5,0xA4,
 0x3A,0x5B,0x99,0x95,0x88,0x49,0xB7,0xB4,0x68,0x8A,0xA7,0xB5,0x78,0x4C,0x9A,0xA5,
 0x78,0x5A,0x87,0xB5,0x78,0x5C,0x6B,0xA6,0x78,0x5A,0xA7,0xB3,0x58,0x2D,0x89,0xD5,

 // _ - phomeme 'f'
 0x65,0x66,0x6A,0x66,0xA7,0x98,0x66,0x6A,0x66,0xA7,0xA6,0x67,0x66,0x68,0xA6,0x6A,
 0x67,0xA7,0x98,0x66,0x66,0xA7,0x9A,0xA5,0x86,0x66,0x77,0x68,0xA6,0x9A,0x59,0x66,
 0x89,0xA7,0x89,0x65,0x68,0x86,0xA6,0x76,0x68,0x86,0x66,0xAA,0x68,0x66,0x6A,0x76,
 0x86,0x76,0x7A,0x66,0xA6,0x6A,0x7A,0x66,0xA6,0x8A,0x76,0x7A,0x8A,0x95,0x6A,0xA6,

 // ` - phoneme 'z'
 0x89,0x89,0x89,0xA8,0x99,0x9A,0xA9,0x9A,0xBA,0x9A,0x9A,0xA9,0x89,0x89,0x88,0x79,
 0x87,0x77,0x67,0x66,0x67,0x76,0x76,0x67,0x77,0x77,0x88,0x97,0x89,0x99,0x99,0xAA,
 0xA9,0x9A,0xAA,0xA9,0x9A,0x99,0x89,0x99,0x87,0x78,0x77,0x67,0x77,0x76,0x66,0x67,
 0x66,0x77,0x87,0x77,0x89,0x88,0x89,0x89,0x89,0xA8,0x99,0x9A,0xA9,0x9A,0xBA,0x9A,

 //a - pause
 0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,
 0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,
 0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,
 0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,

 // b - phoneme 'th'
 0x88,0x88,0x87,0x88,0x79,0x86,0x88,0x76,0x86,0x86,0x66,0x66,0x76,0x78,0x98,0x88,
 0x8A,0x99,0x88,0x89,0x79,0x7A,0x8A,0x99,0x89,0xA8,0x98,0x98,0x68,0x88,0x89,0x79,
 0x78,0x78,0x88,0x86,0x88,0x67,0x68,0x87,0x87,0x85,0x67,0x7A,0x88,0x8A,0x8B,0x9A,
 0xA9,0x99,0xA9,0x98,0xA9,0xA9,0xA8,0x98,0xA8,0x96,0x86,0x76,0x76,0x78,0x76,0x66,

 // c - phoneme 'dh'
 0x67,0x98,0x99,0xA9,0xAA,0x9A,0xAA,0x89,0x88,0x78,0x67,0x76,0x67,0x76,0x87,0x88,
 0x99,0x9A,0xA9,0xAA,0x99,0x99,0x89,0x77,0x77,0x66,0x76,0x77,0x77,0x88,0x88,0xA9,
 0xAA,0xA9,0xAA,0x89,0x88,0x78,0x77,0x77,0x66,0x76,0x77,0x87,0x99,0x99,0xA9,0xAA,
 0x99,0x9A,0x89,0x88,0x77,0x66,0x87,0x99,0x99,0xAA,0xAA,0xA9,0x9A,0x88,0x88,0x77,

 // d - phoneme '/u`'
 0xD6,0xFC,0xCD,0x9C,0x88,0x88,0x56,0x44,0x76,0xBA,0xAB,0x99,0x89,0x78,0x56,0x44,
 0x65,0x98,0x99,0x99,0x99,0x89,0x56,0x45,0x64,0x87,0x88,0x98,0x99,0x99,0x68,0x55,
 0x65,0x86,0xA9,0xBB,0xAB,0x8A,0x68,0x56,0x66,0x87,0x88,0x88,0x78,0x56,0x55,0x55,
 0x55,0x65,0x66,0x66,0x56,0x66,0x55,0x55,0x56,0x45,0x65,0x87,0x88,0x66,0x55,0x55,

 // e - phoneme 'zh'
 0x98,0x89,0xAA,0x99,0xAA,0x89,0x89,0x67,0x77,0x66,0x77,0x76,0x88,0x97,0xA9,0xA9,
 0xAB,0x99,0x99,0x87,0x78,0x76,0x67,0x76,0x77,0x97,0x89,0xA9,0x9A,0xB9,0x99,0x99,
 0x78,0x88,0x66,0x76,0x66,0x87,0x88,0xA9,0x99,0xAA,0x99,0x9A,0x88,0x88,0x76,0x67,
 0x66,0x77,0x86,0x88,0x98,0x98,0x89,0xAA,0x99,0xAA,0x89,0x89,0x67,0x77,0x66,0x77,

 // f - phoneme 'eh'
 0x55,0x87,0xF4,0x8F,0x95,0x8F,0x23,0x67,0x86,0x75,0xFB,0x79,0xB8,0x29,0x53,0x76,
 0x66,0xB8,0x9C,0x78,0x88,0x45,0x65,0x87,0x97,0xAA,0x89,0x87,0x56,0x55,0x76,0x88,
 0x99,0x8A,0x68,0x66,0x55,0x76,0xAB,0x98,0xBA,0x58,0x65,0x56,0x76,0x99,0x89,0x88,
 0x68,0x55,0x66,0x66,0x98,0x88,0x77,0x66,0x55,0x56,0x66,0x66,0x86,0x57,0x87,0x56,

 // g - phonemem 'uh'
 0x21,0x32,0x44,0x44,0x64,0x86,0xAA,0x9A,0x77,0xB9,0xFD,0xFF,0xCD,0xBA,0xCB,0xCB,
 0x8A,0x55,0x65,0xA7,0xAA,0x89,0x98,0xB9,0xCC,0xAB,0x68,0x66,0x88,0x78,0x57,0x55,
 0x97,0xBA,0xAB,0x9A,0x99,0xAA,0x9A,0x68,0x66,0x86,0x98,0x99,0xDB,0xFD,0xFF,0xDF,
 0xAB,0x89,0x88,0x68,0x55,0x55,0x76,0x88,0x78,0x56,0x66,0x66,0x56,0x34,0x22,0x32,

 //UNUSED
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
};

static const SOUND_INDEX SoundIndex[41] PROGMEM= {
                    // Sound   Phoneme
    { 0, 0,10},     // A
    { 1, 0,10},     // B
    { 2, 0,10},     // C
    { 3, 0,10},     // D
    { 4, 0, 8},     // E
    { 5, 0,12},     // F
    { 6, 0, 8},     // G
    { 7, 0, 1},     // H
    { 8, 0, 1},     // I
    { 9, 0, 1},     // J
    {10, 0, 6},     // K
    {11,-1, 0},     // L        v (add 'f')
    {12, 1,12},     // M
    {13, 2, 0},     // N
    {14, 1,12},     // O
    {15, 1,12},     // P
    {16, 1,12},     // Q
    {17, 0, 6},     // R
    {18, 0, 6},     // S
    {19, 0, 6},     // T
    {20, 0, 6},     // U
    {21,-4, 0},     // V        j (add 'sh')
    {22, 1,12},     // W
    {23, 0, 4},     // X
    {24, 0, 8},     // Y
    {25, 0, 6},     // Z
    {26, 0,10},     // [
    {27, 2, 0},     // '\\'   
    {28, 1,12},     // ]
    {29, 2, 0},     // ^        s
    {30, 2, 0},     // _        f
    {31,-2, 0},     // `        z (add 's')
    {32, 0,10},             // a
    {33, 2, 0},     // b        th
    {34,-3, 0},     // c        dh (add 'th')
    {35, 0, 6},     // d
    {36,-4, 0},     // e        zh (add 'sh')
    {37, 0, 8},     // f
    {38, 0, 8},     // g
    {32, 0,10},     // h
    {32, 0,10}      // i
};


#endif