// SPI serial flash test from teensy SerialFlash
//  SPI pins  CS on 6
//  TODO SPI CS pins part of class definitions
#include "mbed.h"
#include "SerialFlash.h"

void dump(int addr, int lines) {
    int i;
    char buf[16];

    while(lines--){
        SerialFlash.read(addr,buf,16);
        addr += 16;
        for(i=0;i<16;i++) printf("%02x ",buf[i]);
        printf("|");
        for(i=0;i<16;i++){
            if (buf[i] < ' ' | buf[i]  > '\177') printf("?");
            else printf("%c",buf[i]);
        }
        printf("|\n");
    }
}

void meta() {
  //  paul's file system meta data
  int i,files,deleted,capacity, avail;
  uint32_t maxfiles, stringsize, buff, dir[2];
  uint16_t hash;
  uint8_t id[3];

  printf("meta data: magic(4),strsize/4(2),maxfiles(2)  hashes*2\n");
  dump(0,2);
  SerialFlash.read(4,&buff,4);
  maxfiles = buff & 0xffff;
  stringsize = (buff & 0xFFFF0000) >> 14;
  printf("maxfiles %d  stringsize %d\n",maxfiles,stringsize);
  printf("dir: entry(10): addr(4),lth(4),str/4(2)\n");
  dump(8 + maxfiles*2,3);
  printf("strings\n");
  dump(8 + 12*maxfiles,3);
  printf("first data block\n");
  i = 8 + maxfiles*2 + maxfiles*10 + stringsize;
  dump(i,1);
  files=deleted=hash=0;
  for(i=0;i<maxfiles;i++) {
    SerialFlash.read(8+2*i,&hash,2);
    if (hash == 0xffff) break;
    if (hash) files++;
    else deleted++;
  }
  printf("files %d  deleted %d\n",files,deleted);
  SerialFlash.opendir();
  while (1) {
    char filename[64];
    uint32_t filesize;

    if (SerialFlash.readdir(filename, sizeof(filename), filesize)) {
      printf("%s  %d bytes\n",filename,filesize);
    } else {
      break; // no more files
    }
  }
  
  SerialFlash.readID(id);
  capacity = SerialFlash.capacity(id);
  printf("Capacity %d ",capacity);
  // read last dir entry  i-1, could round up to 256
  SerialFlash.read(8 + maxfiles*2 + (i-1)*10,dir,8);
  avail = capacity - (dir[0] + dir[1]);
  printf("   free %d\n",avail);
}

void erase() {
    printf("erasing ...");
    SerialFlash.eraseAll();
    while (SerialFlash.ready() == false);
    printf(" done\n");
}

void dofile(char *filename, unsigned long length) {
    printf("create %s %d bytes\n",filename,length);

    // check if this file is already on the Flash chip
    if (SerialFlash.exists(filename)) {
      printf("file exists, removing\n");
      SerialFlash.remove(filename);
    }
  
    // create the file on the Flash chip and copy data
    if (SerialFlash.create(filename, length)) {
      char buf[256];
      unsigned int n;
      int i;
      wait(.002);
      SerialFlashFile ff = SerialFlash.open(filename);
      if (ff) {
        // copy data loop
        while (length) {


          for(i=0;i<sizeof(buf);i++) buf[i]=i;
          if (length >= 256) n =256;
           else n = length;
          ff.write(buf, n);
          length -= n;
          printf(".");
        }
        ff.close();
        printf("\n");
        // check some data
        ff = SerialFlash.open("TST.DAT");
        printf("checking  flash addr %d\n",ff.getFlashAddress());
        dump(ff.getFlashAddress(),2);
        int n,errs=0;
        while(1) {
            n=ff.read(buf,sizeof(buf));
            if (n <= 0) break;
            for (i=0;i<sizeof(buf);i++) if (buf[i] != i) errs++;
        }
        ff.close();
        printf("errs %d\n",errs); 
      } else {
        printf("  error opening freshly created file!\n");
      }
    } else {
      printf("  unable to create file\n");
    }
}

int main()
{
    uint8_t id[3];
    SerialFlash.begin();
    //erase();
    //dofile("TST.DAT",1024);
    while (true) {
        SerialFlash.readID(id);
        printf("%x %x %x\n",id[0],id[1],id[2]);
        dump(0,2);
        meta();
        wait(4.0);
    }
}