// test CRC hardware, stupid only 32-bit words, fixed poly 
// CRC32, CRC-32/ADCCP, PKZIP, ETHERNET, 802.3 
//  (poly=0x04c11db7 init=0xffffffff refin=true refout=true xorout=0xffffffff check=0xcbf43926)
#include "mbed.h"
 
Timer tmr;
#define BUFSIZE 16384

uint8_t buf[BUFSIZE] __attribute__((aligned(4)));


int main() {
    int i;
    
    printf("\nSystemCoreClock %d %s %s\n",SystemCoreClock,__TIME__,__DATE__);
    tmr.start();
    RCC->AHB1ENR |= RCC_AHB1ENR_CRCEN;   // enable CRC
    for ( i=0; i<BUFSIZE; i++) {
        buf[i] = (i+1) & 0xff;
    }
    while(1) {
        uint32_t i,us, *p = (uint32_t *)buf;
    
        CRC->CR = 1;  // reset
        while(CRC->DR != ~0);  // wait for reset
        us = tmr.read_us();
        for(i=0;i<BUFSIZE/4;i++) CRC->DR = __RBIT(p[i]);  
        us = tmr.read_us() - us;
        printf("0x%08x  %d us  ?=0x1271457f\n",~__RBIT(CRC->DR),us);
        us = __RBIT(0x41414141);   // AAAA   crc should be 9b0d08f1
        CRC->CR = 1;   //reset
        while(CRC->DR != ~0);  // wait for reset
        CRC->DR = us;
        printf("%x 0x%x crc(AAAA)=9b0d08f1\n",CRC->DR,~__RBIT(CRC->DR));
        CRC->CR = 1;    // reset
        while(CRC->DR != ~0);  // wait for reset
        CRC->DR = 0;
        printf("0x%x crc(0)=2144df1c\n",~__RBIT(CRC->DR));
    
        wait(5.0); 
    }
}
