// k64 wdog  using 1khz LPO (10% accuracy)
#include "mbed.h"

#define PRREG(z) printf(#z" 0x%x\n",z)
Timer tmr;

void wdog_init(uint32_t ms) {
    __disable_irq();
    WDOG->UNLOCK = WDOG_UNLOCK_WDOGUNLOCK(0xC520); /* Key 1 */
    WDOG->UNLOCK = WDOG_UNLOCK_WDOGUNLOCK(0xD928); /* Key 2 */
    __NOP();
    __NOP();

    WDOG_TOVALL = (uint16_t)(ms & 0xffff); //  sets the time-out value
    WDOG_TOVALH = (uint16_t)((ms>>16) & 0xffff);
    WDOG_STCTRLH = (WDOG_STCTRLH_ALLOWUPDATE_MASK | WDOG_STCTRLH_WDOGEN_MASK | WDOG_STCTRLH_WAITEN_MASK | WDOG_STCTRLH_STOPEN_MASK); // Enable WDG
    WDOG_PRESC = 0; // prescaler 
    __enable_irq();
}

void wdog_disable() {
    __disable_irq();
    WDOG->UNLOCK = WDOG_UNLOCK_WDOGUNLOCK(0xC520); /* Key 1 */
    WDOG->UNLOCK = WDOG_UNLOCK_WDOGUNLOCK(0xD928); /* Key 2 */
    __NOP();
    __NOP();
    WDOG_STCTRLH = WDOG_STCTRLH_ALLOWUPDATE_MASK; 
    __enable_irq();
}

void wdog_kick() {
     __disable_irq();
    WDOG_REFRESH = 0xA602;
    WDOG_REFRESH = 0xB480;
    __enable_irq();
}

int main() {
    int i,fbus,flashbus;
    fbus = SystemCoreClock / (((SIM->CLKDIV1 & SIM_CLKDIV1_OUTDIV2_MASK) >> SIM_CLKDIV1_OUTDIV2_SHIFT) + 1);
    flashbus = SystemCoreClock / (((SIM->CLKDIV1 & SIM_CLKDIV1_OUTDIV4_MASK) >> SIM_CLKDIV1_OUTDIV4_SHIFT) + 1);
    printf("\nSystemCoreClock %d fbus %d flash %d %s %s\n",SystemCoreClock,fbus,flashbus,__TIME__,__DATE__);
    PRREG(RCM_SRS0);   // reset reason
    PRREG(RCM_SRS1);
    PRREG(WDOG->STCTRLH);
    PRREG(WDOG->PRESC);
    PRREG(WDOG->TOVALL);
    PRREG(WDOG->TOVALH);
    PRREG(WDOG->RSTCNT);
    wdog_init(4000);            // 4 sec timeout
    PRREG(WDOG->STCTRLH);
    PRREG(WDOG->PRESC);
    PRREG(WDOG->TOVALL);
    PRREG(WDOG->TOVALH);

    wait_ms(100);
    wdog_kick();
    for (i=1;i<=5; i++) {
        printf("running %d\n",i);
        wait(1.0);
        wdog_kick();
    }
    printf("long wait reset\n");
    wait(5.0);
    printf("never happen\n");
}