// k64f rtcisr
// seconds interrupt from RTC compare micros() to check RTC frequency
#include "mbed.h"

#define micros tmr.read_us

DigitalOut led(LED_RED);
Timer tmr;

volatile static unsigned long ticks,us;
static unsigned long us0=0;

extern "C" void RTC_Seconds_IRQHandler() {
    if (us0 == 0) us0 = micros();
      else {
        ticks++;
        us = micros() - us0;
    }
    led = !led; // toggle led
}

int main(){
    int ppm, tprev=0;

    tmr.start();   // for micros
    time(NULL);  // start RTC
    RTC_IER = 0x10 ;    //TSIE enable seconds interrupt
    NVIC_EnableIRQ(RTC_Seconds_IRQn);
    while (true) {
        ppm = 1000000*ticks - us;
        ppm = 1.e6 * ppm/ (float)us;
        printf("%d %d %f %d\n",ticks,ticks-tprev,us*1.e-6,ppm);
        wait(2.0);
    }
}