//  ppmtest  port of teensy 3 PulsePosition lib
// use PWM pins on FTM0 D3,D5,D6,D7,D8,D9
#include "mbed.h"
#include "PulsePosition.h"

volatile extern uint32_t ticks;
// Simple loopback test: create 1 output to transmit
// test pulses, and 1 input to receive the pulses
PulsePositionOutput myOut;
PulsePositionInput myIn;

main() {
  printf("\nSystemCoreClock %d %s %s\n",SystemCoreClock,__TIME__,__DATE__);
  myOut.begin(D3);  // connect pins D3 D5
  myIn.begin(D5);
  printf("%0X\n",PORTA_PCR1);
  myOut.write(1, 600.03);
  myOut.write(2, 1500);
  myOut.write(3, 759.24);
  // slots 4 and 5 will default to 1500 us
  myOut.write(6, 1234.56);

 printf("looping\n");
 while(true) {
  static int count=0;
  int i, num;

  // Every time new data arrives, simply print it

  num = myIn.available();
  if (num > 0) {
    count = count + 1;
    printf("%d : ",count);
    for (i=1; i <= num; i++) {
      float val = myIn.read(i);
      printf("%f ",val);
    }
    printf("\n");
  }
 }
}