// check pwm and 50us values for IRremote  IRremoteInt.h
// CMT timer ch 39,  pin pg 196  CMT_IRO PTD7  on 2x4 RF header
// derived from teensy 3 IRremote lib
// https://forum.pjrc.com/threads/26331-IRRemote-issues?p=52316&viewfull=1#post52316

#include "mbed.h"

static uint32_t khz=40, CMT_PPS_VAL, fbus=60000000, cmd2=30, cmd4=19;
DigitalOut led(LED1);

volatile uint32_t ticks;

extern "C" void CMT_IRQHandler() {
     uint8_t tmp = CMT_MSC;  // reset interrupt
     CMT_CMD2 = 30; 
     led = !led; 
     ticks++;
}

//  ref 39.7.3.1  30+1+19 = 50us period
void init1() {
    SIM_SCGC4 |= (1<<SIM_SCGC4_CMT_SHIFT);
    CMT_PPS = CMT_PPS_VAL;    // 8 mhz
    CMT_CGH1 = 1;
    CMT_CGL1 = 1;
    CMT_CMD1 = 0;
    CMT_CMD2 = cmd2;    // mark low down counter  8-bit
    CMT_CMD3 = 0;
    CMT_CMD4 = cmd4;    // space low  period  8-bit
    CMT_OC = 0;
    CMT_MSC = 0x03;     // enable CMT and interrupt
    NVIC_EnableIRQ(CMT_IRQn);
}

void init_pwm(int khz) {
    SIM_SCGC4 |= (1<<SIM_SCGC4_CMT_SHIFT);
    SIM_SOPT2 |= (1 << SIM_SOPT2_PTD7PAD_SHIFT);   // drive strength
    CMT_PPS = CMT_PPS_VAL;    // 8 mhz
    CMT_CGH1 = 2667 / khz;    // high time  30% duty  8-bit  ticks*.125us
    CMT_CGL1 = 5333 / khz;    // low time
    CMT_CMD1 = 0;
    CMT_CMD2 = cmd2;              // no effect
    CMT_CMD3 = 0;
    CMT_CMD4 = 0;               // space low
    CMT_OC = 0x60;     // enable IRO
    CMT_MSC = 0x01; // enable

    SIM_SCGC5 |= (1 << SIM_SCGC5_PORTD_SHIFT);  // power PORTD
    PORTD_PCR7 = PORT_PCR_MUX(2)|(1<< PORT_PCR_DSE_SHIFT)|(1 << PORT_PCR_SRE_SHIFT);
}

main() {
  // get F_BUS freq
  fbus = SystemCoreClock / (((SIM->CLKDIV1 & SIM_CLKDIV1_OUTDIV2_MASK) >> SIM_CLKDIV1_OUTDIV2_SHIFT) + 1);
  printf("\nSystemCoreClock %d  bus %d  %s %s\n",SystemCoreClock,fbus,__TIME__,__DATE__);
  if (fbus == 48000000) CMT_PPS_VAL = 5 ;
  else if (fbus == 24000000)CMT_PPS_VAL = 2 ;
  else if (fbus == 16000000) CMT_PPS_VAL= 1 ;
  else if (fbus ==  8000000)CMT_PPS_VAL = 0 ;
  else if (fbus == 56000000)CMT_PPS_VAL = 6 ;
  else if (fbus == 36000000) { CMT_PPS_VAL = 3 ; cmd4=25; khz=(32*khz)/36; }
  else if (fbus == 60000000) { CMT_PPS_VAL = 6 ; cmd4=23; khz = (56*khz)/60; }
  else if (fbus ==  4000000) { CMT_PPS_VAL = 0 ; cmd2=5;  khz=2*khz; }
  else if (fbus ==  2000000) { CMT_PPS_VAL = 0 ; cmd2=5; cmd4=7; khz=4*khz; }


#if 1
  init_pwm(khz);    // pwm freq in khz
  while(true) {
      led= !led;
      wait(1.0);
  }
#else
    init1();      // 50us interrupts
    while(true) {
        printf("ticks %d\n",ticks);
        wait(2.);
    }
#endif
}

