//#include <iostream>
#include "Organism.h"
#include "World.h"

// Create an organism at the given coordinates in the given world.
Organism::Organism(World* aWorld, int xcoord, int ycoord) {
  world = aWorld;
  x = xcoord;
  y = ycoord;
  breedTicks = 0;
  moved = false;
  world->setAt(x, y, this);
}

// flags the organism as moved or not
void Organism::setMoved(bool hasMoved) {
  moved = hasMoved;
}

// has the organism moved or not?
bool Organism::hasMoved() const {
  return moved;
}

// moves the organism from coordinates (x,y) to (xNew,yNew)
void Organism::movesTo(int xNew, int yNew) {

  world->setAt(xNew, yNew, world->getAt(x, y));

  world->setAt(x, y, NULL);

  x = xNew;
  y = yNew;

  world->getAt(x, y)->setMoved(true);
}

// Breeds an organism at an adjacent cell. This method calls the
// generateOffspring() method.
void Organism::breedAtAdjacentCell()  {
#if 1
  // find empty nabor for breeding
  for (int i = 0; i < NABORS; i++) {
    switch (nabors[i]) {
      case 0:
        if ((world->getAt(x, y + 1) == NULL) && in_range(x, y + 1))
        {
          generateOffspring(x, y + 1);
          return;
        }
        break;
      case 1:
        if ((world->getAt(x, y - 1) == NULL) && in_range(x, y - 1))
        {
          generateOffspring(x, y - 1);
          return;
        }
        break;
      case 2:
        if ((world->getAt(x - 1, y) == NULL)  && in_range(x - 1, y))
        {
          generateOffspring(x - 1, y);
          return;
        }
      case 3:
        if ((world->getAt(x + 1, y) == NULL)  && in_range(x + 1, y))
        {
          generateOffspring(x + 1, y);
          return;
        }
        break;
      default:
        break;
    }
  }  // nabor for
#else
  if ((world->getAt(x, y + 1) == NULL) && in_range(x, y + 1))
  {
    generateOffspring(x, y + 1);
  }
  else if ((world->getAt(x, y - 1) == NULL) && in_range(x, y - 1))
  {
    generateOffspring(x, y - 1);
  }
  else if ((world->getAt(x - 1, y) == NULL)  && in_range(x - 1, y))
  {
    generateOffspring(x - 1, y);
  }
  else if ((world->getAt(x + 1, y) == NULL)  && in_range(x + 1, y))
  {
    generateOffspring(x + 1, y);
  }
#endif
}


bool Organism::in_range(int xx, int yy)
{
  return (xx >= 0) && (xx < ROWS) && (yy >= 0) && (yy < COLS);
}
// Returns true if organism is dead, false otherwise.
bool Organism::isDead() const {
  return false;
}
