// capacitive touch  TSC
// select cap pin and sensor pin in same group  datasheet table 17
//  http://www.codeforge.com/read/253659/bsp.c__html

#include "mbed.h"
#include "PeripheralPins.h"
TSC_HandleTypeDef TscHandle;
const PinMap PinMap_TSC[] = {
    {PB_6,  (int)TSC, STM_PIN_DATA(STM_MODE_AF_PP, GPIO_NOPULL, 9)},  // AF9 OUTPUT or AF?
    {PB_7,  (int)TSC, STM_PIN_DATA(STM_MODE_AF_OD, GPIO_NOPULL, 9)},  // need capacitor
    {NC,    NC,    0}
};

#define PRREG(z) printf(#z" 0x%x\n",z)
Timer tmr;

main() {
    tmr.start();
    __HAL_RCC_TSC_CLK_ENABLE();   // enable TSC
    // enable GPIO and config pins 
    __HAL_RCC_GPIOB_CLK_ENABLE();
    //HAL_GPIO_Init();   // mux function 9
    pin_function(PB_6,pinmap_find_function(PB_6,PinMap_TSC));
    pin_function(PB_7,pinmap_find_function(PB_7,PinMap_TSC));

  TscHandle.Instance = TSC;
  TscHandle.Init.AcquisitionMode         = TSC_ACQ_MODE_NORMAL;
  TscHandle.Init.CTPulseHighLength       = TSC_CTPH_2CYCLES;
  TscHandle.Init.CTPulseLowLength        = TSC_CTPL_2CYCLES; 
  TscHandle.Init.IODefaultMode           = TSC_IODEF_IN_FLOAT;
  TscHandle.Init.MaxCountInterrupt       = DISABLE;
  TscHandle.Init.MaxCountValue           = TSC_MCV_8191;
  TscHandle.Init.PulseGeneratorPrescaler = TSC_PG_PRESC_DIV32; 
  TscHandle.Init.SpreadSpectrum          = DISABLE;
  TscHandle.Init.SpreadSpectrumDeviation = 127;
  TscHandle.Init.SpreadSpectrumPrescaler = TSC_SS_PRESC_DIV1;
  TscHandle.Init.SynchroPinPolarity      = TSC_SYNC_POL_FALL;
  /* All channel, shield and sampling IOs must be declared below */
  TscHandle.Init.ChannelIOs              =  TSC_GROUP2_IO3;   // PB6  output push-pull sensor 
  TscHandle.Init.SamplingIOs             =  TSC_GROUP2_IO4;   // PB7  output open drain  need capacitor
  TscHandle.Init.ShieldIOs               = 0;
  HAL_TSC_Init(&TscHandle);
  PRREG(GPIOB->MODER);
  PRREG(GPIOB->OTYPER);
  PRREG(GPIOB->PUPDR); 
  PRREG(GPIOB->AFR[0]); 
  PRREG(GPIOB->AFR[1]);
  PRREG(TSC->CR); 
  PRREG(TSC->IOASCR);
  PRREG(TSC->IOSCR);
  PRREG(TSC->IOCCR);
  
  while(1) {
    uint32_t us = tmr.read_us();    
    HAL_TSC_Start(&TscHandle);
    HAL_TSC_PollForAcquisition(&TscHandle);
    uint32_t val = HAL_TSC_GroupGetValue(&TscHandle,1);  // group 2  0 to 7 or 1 to 8
    us=tmr.read_us() - us;
    int avrg=0;
    for(int i=0;i<100;i++) {
        HAL_TSC_Start(&TscHandle);
        HAL_TSC_PollForAcquisition(&TscHandle);
        avrg += HAL_TSC_GroupGetValue(&TscHandle,1); 
    }
    printf("%d  %d us   avrg %d\n",val,us,avrg/100);
    PRREG(TSC->IOGCSR);
    wait(2.0);
  }
  
}