#define RECV_TIMER 2
// maple pwm pin/timer/channel predefined and vary by processor
//  maple RET6
#define PWM_PIN 24
#define PWM_TIMER 4
#define PWM_TIMER_CH TIMER_CH4
#define PWM_DUTY 2    //2 50%   4 25% hi

#define RAWBUF 76 // Length of raw duration buffer

#define USECPERTICK 50  // microseconds per clock interrupt tick

// Marks tend to be 100us too long, and spaces 100us too short
// when received due to sensor lag.
#define MARK_EXCESS 100

// Values for decode_type
#define NEC 1
#define SONY 2
#define RC5 3
#define RC6 4
#define UNKNOWN -1

#define TOLERANCE 25  // percent tolerance in measurements
#define LTOL (1.0 - TOLERANCE/100.) 
#define UTOL (1.0 + TOLERANCE/100.) 

#define TICKS_LOW(us) (int) (((us)*LTOL/USECPERTICK))
#define TICKS_HIGH(us) (int) (((us)*UTOL/USECPERTICK + 1))

#define MATCH(measured_ticks, desired_us) ((measured_ticks) >= TICKS_LOW(desired_us) && (measured_ticks) <= TICKS_HIGH(desired_us))
#define MATCH_MARK(measured_ticks, desired_us) MATCH(measured_ticks, (desired_us) + MARK_EXCESS)
#define MATCH_SPACE(measured_ticks, desired_us) MATCH((measured_ticks), (desired_us) - MARK_EXCESS)


#define _GAP 5000 // Minimum gap between transmissions  us
#define GAP_TICKS (_GAP/USECPERTICK)

// receiver states
#define STATE_IDLE     2
#define STATE_MARK     3
#define STATE_SPACE    4
#define STATE_STOP     5

// IR detector output is active low
#define MARK  0
#define SPACE 1

#define TOPBIT 0x80000000

#define ERR 0
#define DECODED 1

// duration in us
#define SONY_HDR_MARK   2400
#define SONY_HDR_SPACE  600
#define SONY_ONE_MARK   1200
#define SONY_ZERO_MARK  600
#define SONY_RPT_LENGTH 45000
#define SONY_BITS 12
