#include "mbed.h"
#include "string"
#include "player.h"
#include "SDFileSystem.h"
//Player mp3
SDFileSystem sd(D11, D12, D13, D9, "sd"); // the pinout on the mbed Cool
vs10xx vs1053(D11, D12, D13, D6, D7, D2, D8);//mosi,miso,sclk,xcs,xdcs,dreq,xreset
playerStatetype  playerState;
static unsigned char fileBuf[32768];
unsigned char *bufptr;
char green;
char list[20][50];            //song list
extern playerStatetype  playerState; 
//
DigitalOut pinout(PC_4);
//Serial
Serial pc(USBTX, USBRX);
Serial sensor_node(PA_15, PB_7);
Serial nextion(PC_6,PA_12);
int input;
int data_buffer[20];

//DATA
struct DATA
{
    int height;
    int weight;
    int sys;
    int dia;
    int hr;
    int bp_status; // BP error
    int pattern; // led ring pettern 97, 98, 99, ...
    int data_status; //0 = not ready to push to cloud
    
};
struct DATA measured_data;

void depacket(struct DATA &input);
void print_data(struct DATA &input);

void write_rgb(int pattern){sensor_node.printf("%c",pattern);}
// mp3 function
void begin(void)
{
    DirHandle *dir;
    struct dirent *ptr;
        FileHandle *fp;
   
    vs1053.reset();
    dir = opendir("/sd");
    printf("\r\n**********playing list**********\r\n");
    unsigned char i = 0,j=0;
    while(((ptr = dir->readdir()) != NULL)&&(i <20))
    {
        if(strstr(ptr->d_name,".mp3")||strstr(ptr->d_name,".MP3"))
        {
                            fp =sd.open(ptr->d_name, O_RDONLY);
                            if(fp != NULL) 
                            {
                                char *byte = ptr->d_name;
                                j=0;
                                while(*byte){
                                list[i][j++]  = *byte++;
                                green=i;
                }
                pc.printf("%2d . %s\r\n", i,list[i++]);
                //fp->close();
                            }
        }
    }
        dir->closedir();
}
void stop(void){
    playerState =PS_STOP;
    }
    
void playFile(char *file) {
    int bytes;        // How many bytes in buffer left
    char n;
    
    playerState = PS_PLAY;
    
    vs1053.setFreq(24000000);     //hight speed
    
    FileHandle *fp =sd.open(file, O_RDONLY);
    
    if(fp == NULL) {
        printf("Could not open %s\r\n",file);

    }
    else
    {
        printf("Playing %s ...\r\n",file);
        
        /* Main playback loop */
        while((bytes = fp->read(fileBuf,32768)) > 0) {
        while((bytes = fp->read(fileBuf,32000)) > 0) {
        {
            bufptr = fileBuf;
            // actual audio data gets sent to VS10xx.
            while(bytes > 0)
            {
                n = (bytes < 32)?bytes:32; 
                vs1053.writeData(bufptr,n);
                bytes -= n;
                bufptr += n;
                
            }
            uint8_t vol = 0x00;//set vlume
            vs1053.setVolume(vol);  //set vlume
            
            if(playerState != PS_PLAY)         //stop
            {
                fp->close();
                vs1053.softReset();
            }
                
                }
            }
        }
    }

}
//// end mp3 

/// nextion function
void end(void)
{
    nextion.putc(0xff);
    nextion.putc(0xff);
    nextion.putc(0xff);
    
    }
bool printed_0 = 0; 
bool printed_1 = 0;
bool printed_2 = 0; 
bool printed_3 = 0;
bool printed_4 = 0;
bool printed_5 = 0; 
bool printed_6 = 0;
bool printed_7 = 0;  

    
void write_page_0(void){//Sam 
    printed_1 = 0;
    printed_2 = 0; 
    printed_3 = 0;
    printed_4 = 0;
    printed_5 = 0; 
    printed_6 = 0;
    printed_7 = 0; 
    if (!printed_0){ 
    
        nextion.printf("page page0");
        playFile("track0.mp3");
        stop();
        printed_0 = 1;
        end();
    }
}
void write_page_1(void){//please stand
    printed_0 = 0; 
    printed_2 = 0; 
    printed_3 = 0;
    printed_4 = 0;
    printed_5 = 0; 
    printed_6 = 0;
    printed_7 = 0; 
    if (!printed_1){ 
    
        nextion.printf("page page1");
        playFile("track1.mp3");
        stop();
        printed_1 = 1;
        end();
    }
}

void write_page_2(int height,int weight){//show height
    printed_0 = 0; 
    printed_1 = 0;
    printed_3 = 0;
    printed_4 = 0;
    printed_6 = 0;
    printed_7 = 0; 
    printed_5 = 0;
    if (!printed_2){
        nextion.printf("page page2");
        printed_2 = 1;
        end();
    }
    nextion.printf("height.val=%d",height);
    end();
    nextion.printf("weight.val=%d",weight);
    end();
}

void write_page_3(void){//put right arm
    printed_1 = 0;
    printed_2 = 0; 
    printed_0 = 0;
    printed_4 = 0;
    printed_5 = 0; 
    printed_6 = 0;
    printed_7 = 0; 
    if (!printed_3){ 
        nextion.printf("page page3");
        playFile("track3.mp3");
        stop();
        printed_3 = 1;
        end();
    }
}

void write_page_4(void){//while blood
    printed_1 = 0;
    printed_2 = 0; 
    printed_3 = 0;
    printed_0 = 0;
    printed_5 = 0; 
    printed_6 = 0;
    printed_7 = 0; 
    if (!printed_4){ 
        nextion.printf("page page4");
        playFile("track4.mp3");
        stop();
        printed_4 = 1;
        end();
    }
}

void write_page_5(int sys,int dia,int pulse){//show blood
    printed_1 = 0;
    printed_2 = 0; 
    printed_3 = 0;
    printed_4 = 0;
    printed_0 = 0; 
    printed_6 = 0;
    printed_7 = 0; 
    if (!printed_5){
        nextion.printf("page page5");
        printed_5 = 1;
        end();
    }
    nextion.printf("sys.val=%d",sys);
    end();
    nextion.printf("dia.val=%d",dia);
    end();
    nextion.printf("pulse.val=%d",pulse);
    end();
}

void write_page_6(void){//blood failed
    printed_1 = 0;
    printed_2 = 0; 
    printed_3 = 0;
    printed_4 = 0;
    printed_5 = 0; 
    printed_0 = 0;
    printed_7 = 0;
    if (!printed_6){ 
    
        nextion.printf("page page6");
        playFile("track6.mp3");
        stop();
        printed_6 = 1;
        end();
    }
}

void write_page_7(void){//see you
    printed_1 = 0;
    printed_2 = 0; 
    printed_3 = 0;
    printed_4 = 0;
    printed_5 = 0; 
    printed_6 = 0;
    printed_0 = 0; 
    if (!printed_7){ 
        
        nextion.printf("page page7");
        playFile("track7.mp3");
        stop();
        printed_7 = 1;
        end();
    }
}
//// end nextion


int main() {
    
    bool debug = 1;
    begin();
    while(1){
        write_page_3(); 
        
        depacket(measured_data);
        if (debug)
            print_data(measured_data);
        write_rgb(measured_data.pattern);
        
        if (measured_data.data_status == 0){
            write_page_0();   
        }
        else if (measured_data.data_status == 1){
            write_page_1();   
        }
        else if (measured_data.data_status == 2){
            write_page_2(measured_data.height, measured_data.weight);   
        }
        else if (measured_data.data_status == 3){
            write_page_3();  
            input=nextion.getc();
            if(input==148){
                pinout=1;
                wait(0.5);
                pinout=0;
                //pc.printf("a\n");
            } 
        }
        else if (measured_data.data_status == 4){
            write_page_4(); 
        }
        else if (measured_data.data_status == 5){
            write_page_5(measured_data.sys, measured_data.dia, measured_data.hr);   
        }
        else if (measured_data.data_status == 6){
            write_page_6();   
        }
       
    }
}

void depacket(struct DATA &input){
    if (sensor_node.readable()){
            
            int temp =sensor_node.getc();
            //if (temp == 255){
                int cnt = 0;
                while(1){
                    data_buffer[cnt]=sensor_node.getc();
                    if (cnt == 8)break;
                    if (data_buffer[cnt] == 255)cnt = 0;
                    else if (data_buffer[cnt] != 255)cnt++;
                }
                measured_data.height = data_buffer[0];
                measured_data.weight = data_buffer[1];
                input.sys = data_buffer[2];
                input.dia = data_buffer[3];
                input.hr = data_buffer[4];
                input.bp_status = data_buffer[5];
                input.pattern = data_buffer[6];
                input.data_status = data_buffer[7];
                
            
    }
}

void print_data(struct DATA &input){
    pc.printf("H : %d  ", input.height);
    pc.printf("W : %d  ", input.weight);   
    pc.printf("SYS : %d  ", input.sys);   
    pc.printf("DIA : %d  ", input.dia);   
    pc.printf("PUL : %d  ", input.hr);   
    pc.printf("BPs : %d  ", input.bp_status);   
    pc.printf("PAT : %d  ", input.pattern);   
    pc.printf("STATE : %d", input.data_status); 
    pc.printf("\n");     
}