#include "mbed.h"
#include "BLE.h"
#include "WeatherService.h"
#include "bme280.h"
#define I2C_SDA P0_0
#define I2C_SCL P0_1

float t;
float pr;
float h;

uint8_t address = 0x78;

I2C i2c(I2C_SDA, I2C_SCL);

BLE ble;

DigitalOut okLED(LED1);
DigitalOut errLED(LED2);
DigitalOut instrumentsPower(P0_22);

BME280 bme280;

const static char DEVICE_NAME[] = "Weather Station";

static const uint16_t serviceList[] = {
    GattService::UUID_ENVIRONMENTAL_SERVICE
};

static volatile bool triggerSensorPolling = false;

//bme280
void i2cWrite(uint8_t i2c_address, uint8_t *p_data, uint8_t data_size, uint8_t repeated_start)
{
// mbed uses 8-bit addresses, always confusing.
    i2c.write(i2c_address<<1,(const char *)p_data,data_size,repeated_start);
}

void i2cRead(uint8_t i2c_address, uint8_t *p_data, uint8_t data_size)
{
// mbed uses 8-bit addresses, always confusing.
    i2c.read(i2c_address<<1,(char *)p_data,data_size);
}

void disconnectionCallback(const Gap::DisconnectionCallbackParams_t *params)
{
/* Restart Advertising on disconnection*/
    ble.gap().startAdvertising();
}

void blink(void)
{
//    statusLED = !statusLED;
    triggerSensorPolling = true;
}

void updateFromBME280()
{
    bme280.read();
    t = bme280.temperature();
//    float p = bme280.pressure()/100;
//    pr = p*0.750062;
    pr = bme280.pressure();
    h = bme280.humidity();
}


int main(void)
{
    okLED = 0;
    errLED = 0;

    Ticker ticker;
    ticker.attach(blink, 5);

    ble.init();

    bme280.begin(BME280_I2C_ADDRESS1);
    // Configure for test purposes.
    bme280.writeConfigRegister(BME280_STANDBY_500_US,BME280_FILTER_OFF,0);
    bme280.writeControlRegisters(BME280_OVERSAMPLING_1X,BME280_OVERSAMPLING_1X,BME280_OVERSAMPLING_1X,BME280_MODE_NORMAL);


    ble.gap().onDisconnection(disconnectionCallback);

    /* Setup weather service. */
    WeatherService weatherService(ble);

    /* setup advertising */
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED | GapAdvertisingData::LE_GENERAL_DISCOVERABLE);
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_16BIT_SERVICE_IDS, (uint8_t *)serviceList, sizeof(serviceList));
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::UNKNOWN);
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LOCAL_NAME, (uint8_t *)DEVICE_NAME, sizeof(DEVICE_NAME));
    ble.gap().setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    ble.gap().setAdvertisingInterval(1000); /* 1000ms */
    ble.gap().startAdvertising();

    while (true) {
        if (triggerSensorPolling && ble.getGapState().connected) {
            okLED = 1;
            triggerSensorPolling = false;

            instrumentsPower = 1;
            wait(1);
            updateFromBME280();
            instrumentsPower = 0;

            weatherService.updateTemperature(t);
            weatherService.updatePressure(pr);
            weatherService.updateHumidity(h);

        } else {
            okLED = 0;
            ble.waitForEvent();
        }
    }
}
