#include "mbed.h"
#include "SSD1306.h"
#include "bme280.h"
#include "stdlib.h"
#include "mbed_logo.h"
#include "mammoth.h"
//nrf51822 temperature
#include "nrf.h"
#include "nrf_temp.h"
//buzzer test
#include "beep.h"

//Присваиваем пины для i2c
#define D_SDA                  P0_0
#define D_SCL                  P0_1

//Функции обработки событий кнопок
void triggerfall_1();   //Button1 falling interrupt function
void triggerrise_1();   //Button1 rising interrupt function
void triggerfall_2();   //Button2 falling interrupt function
void triggerrise_2();   //Button2 rising interrupt function
//глобальные переменные для bme280
float t;    //температура градусы цельсия
float pr;   //давление мм ртутного столба
int h;      //влажность %

int flag;

//buzzer test
Beep buzzer(P0_2);

//адрес дисплея
uint8_t address = 0x78;
//инициализация i2c
I2C i2c(D_SDA, D_SCL);

SSD1306 oled(i2c, address);
BME280 bme280;

//Initiate IO
DigitalOut led0(LED1);
DigitalOut led1(LED2);
DigitalOut led2(P0_20);
DigitalOut led3(P0_21);
DigitalOut led4(P0_22, 0);
DigitalIn  sw1(BUTTON1);
DigitalIn  sw2(BUTTON2);

//Initiate input interrupts
InterruptIn sw1Press(BUTTON1);
InterruptIn sw2Press(BUTTON2);

//bme280
void i2cWrite(uint8_t i2c_address, uint8_t *p_data, uint8_t data_size, uint8_t repeated_start)
{
// mbed uses 8-bit addresses, always confusing.
    i2c.write(i2c_address<<1,(const char *)p_data,data_size,repeated_start);
}

void i2cRead(uint8_t i2c_address, uint8_t *p_data, uint8_t data_size)
{
// mbed uses 8-bit addresses, always confusing.
    i2c.read(i2c_address<<1,(char *)p_data,data_size);
}

//ssd1306
void Start_page()
{
    int i=0;
    oled.writeString(1, 3, "Fight Robot");
    while(i<100) {
        oled.writeProgressBar(20,40,i);
        i++;
        wait_ms(10);
    }
    i = 0;
//    oled.writeBitmap((uint8_t*) mbed_logo);
    oled.writeBitmap((uint8_t*) mammoth);
    while(i<100) {
        i++;
        wait_ms(10);
    }
}
void Display_Meteo(float t, float pr, int h)
{
//    sprintf(buf, "%f", t);
    oled.writeString(1, 2, "T: ");
    oled.printf("%.2f",t);
    oled.printf("%s"," C");
    oled.writeString(3, 2, "P: ");
    oled.printf("%.1f",pr);
    oled.printf("%s"," mmHg");
    oled.writeString(5, 2, "H: ");
    oled.printf("%d",h);
    oled.printf("%s"," %");
}

int main()
{
    flag = 0;
//nrf51822 temperature
    float temp;
    nrf_temp_init();

//Initialise LED output
    led0=0;
    led1=0;
    led2=0;
    led3=0;

//Set falling and rising edge to apppropriate interrup function
    sw1Press.fall(&triggerfall_1);
    sw1Press.rise(&triggerrise_1);
    sw2Press.fall(&triggerfall_2);
    sw2Press.rise(&triggerrise_2);

    bme280.begin(BME280_I2C_ADDRESS1);
// Configure for test purposes.
    bme280.writeConfigRegister(BME280_STANDBY_500_US,BME280_FILTER_OFF,0);
    bme280.writeControlRegisters(BME280_OVERSAMPLING_1X,BME280_OVERSAMPLING_1X,BME280_OVERSAMPLING_1X,BME280_MODE_NORMAL);
    Start_page();
    oled.clearDisplay();

    while(1) {
//nrf51822 temperature
        NRF_TEMP->TASKS_START = 1; /* Start the temperature measurement */
        while ((NRF_TEMP->EVENTS_DATARDY & TEMP_INTENSET_DATARDY_Msk) != (TEMP_INTENSET_DATARDY_Set << TEMP_INTENSET_DATARDY_Pos)) {}
        NRF_TEMP->EVENTS_DATARDY = 0;
        temp = (nrf_temp_read()/4);
        NRF_TEMP->TASKS_STOP = 1; /* Stop the temperature measurement */

        led4=!led4;
        bme280.read();
        t = bme280.temperature();
        float p = bme280.pressure()/100;
        pr = p*0.750062;
        h = bme280.humidity();
        if(flag == 0) {
            Display_Meteo(t, pr, h);

            oled.writeString(7, 2, "T_nRF: ");
            oled.printf("%.1f",temp);
        }
        wait_ms(1000);
    }
}
//Button1 falling interrupt function
void triggerfall_1()
{
//Toggle LED1
    led0=!led0;
    if(flag == 0) {
        oled.clearDisplay();
        flag = 1;
        wait_ms(10);
        oled.writeBitmap((uint8_t*) mammoth);
    }
}

//Button1 rising interrupt function
void triggerrise_1()
{
//Toggle LED2
    led1=!led1;
//buzzer test
    buzzer.beep(1000,0.5);
//    oled.writeBitmap((uint8_t*) mammoth);
}
//Button1 falling interrupt function
void triggerfall_2()
{
//Toggle LED3
    led2=!led2;
    if(flag == 1) {
        oled.clearDisplay();
        flag = 0;
    }
}

//Button1 rising interrupt function
void triggerrise_2()
{
//Toggle LED4
    led3=!led3;
}
